/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.processor.AbstractClientlibRenderer;
import com.composum.sling.clientlibs.processor.CssProcessor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes Clientlib CSS Processor (YUI)"})
public class YUICssProcessor
extends AbstractClientlibRenderer
implements CssProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YUICssProcessor.class);
    @Reference
    private ClientlibConfiguration clientlibConfig;

    @Override
    protected String getLinkTemplate() {
        return this.clientlibConfig.getConfig().template_link_css();
    }

    @Override
    public InputStream processContent(InputStream source, ProcessorContext context) throws IOException {
        InputStream result = source;
        if (source != null) {
            context.hint("jcr:mimeType", "text/css");
            if (context.useMinifiedFiles() && this.clientlibConfig.getConfig().css_minimize()) {
                PipedOutputStream outputStream = new PipedOutputStream();
                result = new PipedInputStream(outputStream);
                context.execute(() -> {
                    try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                         InputStreamReader sourceReader = new InputStreamReader(source, "UTF-8");){
                        CssCompressor compressor = new CssCompressor((Reader)sourceReader);
                        compressor.compress((Writer)writer, this.clientlibConfig.getConfig().css_line_break());
                        writer.flush();
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                });
            }
        }
        return result;
    }
}

