/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.BeanContext;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererContext {
    private static final Logger LOG = LoggerFactory.getLogger(RendererContext.class);
    public static final String CONTEXT_KEY = RendererContext.class.getName() + ".instance";
    protected final Set<ClientlibLink> renderedClientlibs = new LinkedHashSet<ClientlibLink>();
    protected transient ResourceResolver resolver;
    protected transient ClientlibService clientlibService;

    public static RendererContext instance(BeanContext context, SlingHttpServletRequest request) {
        RendererContext attribute = (RendererContext)request.getAttribute(CONTEXT_KEY);
        if (attribute == null) {
            attribute = new RendererContext(context, request);
            request.setAttribute(CONTEXT_KEY, (Object)attribute);
        }
        return attribute;
    }

    protected RendererContext(BeanContext context, SlingHttpServletRequest request) {
        this.clientlibService = context.getService(ClientlibService.class);
        this.resolver = request.getResourceResolver();
    }

    public boolean isClientlibRendered(ClientlibRef reference) {
        for (ClientlibLink link : this.renderedClientlibs) {
            if (!reference.isSatisfiedby(link)) continue;
            LOG.debug("already rendered: {} by {}", (Object)reference, (Object)link.path);
            return true;
        }
        return false;
    }

    public void registerClientlibLink(ClientlibLink link, ClientlibResourceFolder parent) {
        if (this.renderedClientlibs.contains(link)) {
            LOG.info("duplicate clientlib link {} being included from {} ", (Object)link, (Object)parent);
        } else {
            this.renderedClientlibs.add(link);
            LOG.debug("registered {} referenced from {}", (Object)link, (Object)parent);
        }
    }

    public boolean mapClientlibURLs() {
        return this.getConfiguration().clientlibs_url_map();
    }

    public boolean useMinifiedFiles() {
        return this.getConfiguration().clientlibs_minified_use() && !this.getConfiguration().debug();
    }

    public ClientlibService getClientlibService() {
        return this.clientlibService;
    }

    public Set<ClientlibLink> getRenderedClientlibs() {
        return this.renderedClientlibs;
    }

    public ClientlibConfiguration.Config getConfiguration() {
        return this.getClientlibService().getClientlibConfig();
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }
}

