/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.felix.http.sslfilter.internal.SslFilter;

class SslFilterRequest
extends HttpServletRequestWrapper {
    private static final Pattern HEADER_TO_CERT = Pattern.compile("(?! CERTIFICATE)(?= ) ");

    SslFilterRequest(HttpServletRequest request, String clientCertHeader) {
        super(request);
        if (clientCertHeader != null && clientCertHeader.trim().length() > 0) {
            String clientCert = HEADER_TO_CERT.matcher(clientCertHeader).replaceAll("\n");
            try (ByteArrayInputStream instream2 = new ByteArrayInputStream(clientCert.getBytes(StandardCharsets.UTF_8));){
                CertificateFactory fac = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certs = fac.generateCertificates(instream2);
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs.toArray(new X509Certificate[certs.size()]));
            }
            catch (IOException instream2) {
            }
            catch (CertificateException ce) {
                SslFilter.LOGGER.warn("Failed to create SSL filter request! Problem parsing client certificates?! Client certificate will *not* be forwarded...", (Throwable)ce);
            }
        }
    }

    void done() {
        this.getRequest().removeAttribute("javax.servlet.request.X509Certificate");
    }

    public String getScheme() {
        return "https";
    }

    public boolean isSecure() {
        return true;
    }

    public StringBuffer getRequestURL() {
        StringBuffer result = super.getRequestURL();
        if (result.indexOf("http://") == 0) {
            result.insert(4, 's');
        }
        return result;
    }

    public int getServerPort() {
        int port;
        try {
            port = Integer.parseInt(this.getHeader("X-Forwarded-Port"));
        }
        catch (Exception e) {
            port = 443;
        }
        return port;
    }
}

