/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.impl.via.ResourceTypeForcingRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingResourceWrapper;
import org.apache.sling.models.spi.ViaProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceTypeViaProvider
implements ViaProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Object getAdaptable(Object original, String value) {
        if (!this.handle(value)) {
            return ORIGINAL;
        }
        if (original instanceof Resource) {
            Resource resource = (Resource)original;
            String resourceType = this.getResourceType(resource, value);
            if (resourceType == null) {
                this.log.warn("Could not determine forced resource type for {} using via value {}.", (Object)resource, (Object)value);
                return null;
            }
            return new ResourceTypeForcingResourceWrapper(resource, resourceType);
        }
        if (original instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)original;
            Resource resource = request.getResource();
            if (resource == null) {
                return null;
            }
            String resourceType = this.getResourceType(resource, value);
            if (resourceType == null) {
                this.log.warn("Could not determine forced resource type for {} using via value {}.", (Object)resource, (Object)value);
                return null;
            }
            return new ResourceTypeForcingRequestWrapper(request, resource, resourceType);
        }
        this.log.warn("Received unexpected adaptable of type {}.", (Object)original.getClass().getName());
        return null;
    }

    protected abstract boolean handle(@NotNull String var1);

    @Nullable
    protected abstract String getResourceType(@NotNull Resource var1, @NotNull String var2);
}

