/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.Collection;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePropertyUpdateCallback
implements PropertyUpdateCallback {
    private final Collection<PropertyUpdateCallback> callbacks;

    public CompositePropertyUpdateCallback(@NotNull Collection<PropertyUpdateCallback> callbacks) {
        this.callbacks = callbacks;
        Preconditions.checkNotNull(callbacks);
    }

    @Override
    public void propertyUpdated(String nodePath, String propertyRelativePath, PropertyDefinition pd, @Nullable PropertyState before, @Nullable PropertyState after) {
        for (PropertyUpdateCallback callback : this.callbacks) {
            callback.propertyUpdated(nodePath, propertyRelativePath, pd, before, after);
        }
    }

    @Override
    public void done() throws CommitFailedException {
        for (PropertyUpdateCallback callback : this.callbacks) {
            callback.done();
        }
    }
}

