/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.index.search.MoreLikeThisHelperUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

public class MoreLikeThisHelper {
    public static Query getMoreLikeThis(IndexReader reader, Analyzer analyzer, String mltQueryString) {
        Query moreLikeThisQuery = null;
        MoreLikeThis mlt = new MoreLikeThis(reader);
        mlt.setAnalyzer(analyzer);
        try {
            Map<String, String> paramMap = MoreLikeThisHelperUtil.getParamMapFromMltQuery(mltQueryString);
            String text = null;
            String[] fields = new String[]{};
            for (String key : paramMap.keySet()) {
                String value = paramMap.get(key);
                if ("stream.body".equals(key)) {
                    text = value;
                    continue;
                }
                if ("mlt.fl".equals(key)) {
                    fields = value.split(",");
                    continue;
                }
                if ("mlt.mindf".equals(key)) {
                    mlt.setMinDocFreq(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.mintf".equals(key)) {
                    mlt.setMinTermFreq(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.boost".equals(key)) {
                    mlt.setBoost(Boolean.parseBoolean(value));
                    continue;
                }
                if ("mlt.qf".equals(key)) {
                    mlt.setBoostFactor(Float.parseFloat(value));
                    continue;
                }
                if ("mlt.maxdf".equals(key)) {
                    mlt.setMaxDocFreq(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.maxdfp".equals(key)) {
                    mlt.setMaxDocFreqPct(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.maxntp".equals(key)) {
                    mlt.setMaxNumTokensParsed(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.maxqt".equals(key)) {
                    mlt.setMaxQueryTerms(Integer.parseInt(value));
                    continue;
                }
                if ("mlt.maxwl".equals(key)) {
                    mlt.setMaxWordLen(Integer.parseInt(value));
                    continue;
                }
                if (!"mlt.minwl".equals(key)) continue;
                mlt.setMinWordLen(Integer.parseInt(value));
            }
            if (text != null) {
                if (":path".equals(fields[0])) {
                    IndexSearcher searcher = new IndexSearcher(reader);
                    TermQuery q = new TermQuery(new Term(":path", text));
                    TopDocs top = searcher.search((Query)q, 1);
                    if (top.totalHits == 0) {
                        mlt.setFieldNames(fields);
                        moreLikeThisQuery = mlt.like(new StringReader(text), mlt.getFieldNames()[0]);
                    } else {
                        ScoreDoc d = top.scoreDocs[0];
                        Document doc = reader.document(d.doc);
                        ArrayList<String> fieldNames = new ArrayList<String>();
                        for (IndexableField f : doc.getFields()) {
                            if (":path".equals(f.name())) continue;
                            fieldNames.add(f.name());
                        }
                        String[] docFields = fieldNames.toArray(new String[fieldNames.size()]);
                        mlt.setFieldNames(docFields);
                        moreLikeThisQuery = mlt.like(d.doc);
                    }
                } else {
                    mlt.setFieldNames(fields);
                    moreLikeThisQuery = mlt.like(new StringReader(text), mlt.getFieldNames()[0]);
                }
            }
            return moreLikeThisQuery;
        }
        catch (Exception e) {
            throw new RuntimeException("could not handle MLT query " + mltQueryString);
        }
    }
}

