/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDoc;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocumentHolder;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriterFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.index.IndexableField;

public class LocalIndexWriterFactory
implements FulltextIndexWriterFactory<Iterable<? extends IndexableField>> {
    private final LuceneDocumentHolder documentHolder;
    private final String indexPath;

    public LocalIndexWriterFactory(LuceneDocumentHolder documentHolder, String indexPath) {
        this.documentHolder = documentHolder;
        this.indexPath = indexPath;
    }

    public LuceneIndexWriter newInstance(IndexDefinition definition, NodeBuilder definitionBuilder, CommitInfo commitInfo, boolean reindex) {
        return new LocalIndexWriter(definition);
    }

    private class LocalIndexWriter
    implements LuceneIndexWriter {
        private final IndexDefinition definition;

        public LocalIndexWriter(IndexDefinition definition) {
            this.definition = definition;
        }

        @Override
        public void updateDocument(String path, Iterable<? extends IndexableField> doc) throws IOException {
            this.addLuceneDoc(LuceneDoc.forUpdate(this.definition.getIndexPath(), path, doc));
        }

        @Override
        public void deleteDocuments(String path) throws IOException {
        }

        @Override
        public boolean close(long timestamp) throws IOException {
            LocalIndexWriterFactory.this.documentHolder.done(LocalIndexWriterFactory.this.indexPath);
            return false;
        }

        private void addLuceneDoc(LuceneDoc luceneDoc) {
            LocalIndexWriterFactory.this.documentHolder.add(this.definition.isSyncIndexingEnabled(), luceneDoc);
        }
    }
}

