/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.osgi;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.felix.cm.json.Configurations;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.osgi.service.feature.FeatureArtifact;
import org.osgi.service.feature.FeatureArtifactBuilder;
import org.osgi.service.feature.FeatureBuilder;
import org.osgi.service.feature.FeatureBundle;
import org.osgi.service.feature.FeatureBundleBuilder;
import org.osgi.service.feature.FeatureConfiguration;
import org.osgi.service.feature.FeatureExtension;
import org.osgi.service.feature.FeatureExtensionBuilder;
import org.osgi.service.feature.FeatureService;
import org.osgi.service.feature.ID;

public class Converters {
    private static final FeatureService service = ServiceLoader.load(FeatureService.class).iterator().next();
    private static final String FRAMEWORK_PROPERTIES_EXTENSION = "framework-launching-properties";
    private static final String FRAMEWORK_PROPERTIES_METADATA = "framework-properties-metadata";
    private static final String VARIABLES_METADATA = "variables-metadata";

    public static org.osgi.service.feature.Feature convert(Feature feature) throws IOException {
        Map<String, Object> metadata;
        Object writer;
        FeatureBundleBuilder b;
        if (feature == null) {
            return null;
        }
        ID id = service.getIDfromMavenCoordinates(feature.getId().toMvnId());
        FeatureBuilder builder = service.getBuilderFactory().newFeatureBuilder(id);
        builder.setComplete(feature.isComplete());
        builder.setDescription(feature.getDescription());
        builder.setLicense(feature.getLicense());
        builder.setName(feature.getTitle());
        builder.setVendor(feature.getVendor());
        builder.setDocURL(feature.getDocURL());
        builder.setSCM(feature.getSCMInfo());
        for (String v : feature.getCategories()) {
            builder.addCategories(new String[]{v});
        }
        feature.getVariables().entrySet().stream().forEach(entry -> builder.addVariable((String)entry.getKey(), entry.getValue()));
        for (Artifact bundle : feature.getBundles()) {
            b = service.getBuilderFactory().newBundleBuilder(service.getIDfromMavenCoordinates(bundle.getId().toMvnId()));
            bundle.getMetadata().entrySet().stream().forEach(entry -> b.addMetadata((String)entry.getKey(), entry.getValue()));
            builder.addBundles(new FeatureBundle[]{b.build()});
        }
        for (Configuration cfg : feature.getConfigurations()) {
            b = cfg.isFactoryConfiguration() ? service.getBuilderFactory().newConfigurationBuilder(cfg.getFactoryPid(), cfg.getName()) : service.getBuilderFactory().newConfigurationBuilder(cfg.getPid());
            for (String name : Collections.list(cfg.getProperties().keys())) {
                b.addValue(name, cfg.getProperties().get(name));
            }
            builder.addConfigurations(new FeatureConfiguration[]{b.build()});
        }
        for (Extension ext : feature.getExtensions()) {
            FeatureExtension.Type type = ext.getType() == ExtensionType.ARTIFACTS ? FeatureExtension.Type.ARTIFACTS : (ext.getType() == ExtensionType.TEXT ? FeatureExtension.Type.TEXT : FeatureExtension.Type.JSON);
            FeatureExtension.Kind kind = ext.getState() == ExtensionState.OPTIONAL ? FeatureExtension.Kind.OPTIONAL : (ext.getState() == ExtensionState.REQUIRED ? FeatureExtension.Kind.MANDATORY : FeatureExtension.Kind.TRANSIENT);
            FeatureExtensionBuilder b2 = service.getBuilderFactory().newExtensionBuilder(ext.getName(), type, kind);
            if (ext.getType() == ExtensionType.ARTIFACTS) {
                for (Artifact artifact : ext.getArtifacts()) {
                    FeatureArtifactBuilder ab = service.getBuilderFactory().newArtifactBuilder(service.getIDfromMavenCoordinates(artifact.getId().toMvnId()));
                    artifact.getMetadata().entrySet().stream().forEach(entry -> ab.addMetadata((String)entry.getKey(), entry.getValue()));
                    b2.addArtifact(ab.build());
                }
            } else if (ext.getType() == ExtensionType.TEXT) {
                if (ext.getText() != null) {
                    for (String t : ext.getText().split("\n")) {
                        b2.addText(t);
                    }
                }
            } else if (ext.getJSON() != null) {
                b2.setJSON(ext.getJSON());
            } else {
                b2.setJSON("{}");
            }
            builder.addExtensions(new FeatureExtension[]{b2.build()});
        }
        if (!feature.getFrameworkProperties().isEmpty()) {
            FeatureExtensionBuilder b3 = service.getBuilderFactory().newExtensionBuilder(FRAMEWORK_PROPERTIES_EXTENSION, FeatureExtension.Type.JSON, FeatureExtension.Kind.MANDATORY);
            Hashtable properties = new Hashtable();
            feature.getFrameworkProperties().entrySet().stream().forEach(entry -> properties.put((String)entry.getKey(), entry.getValue()));
            writer = new StringWriter();
            try {
                Configurations.buildWriter().build((Writer)writer).writeConfiguration(properties);
                ((Writer)writer).flush();
                b3.setJSON(writer.toString());
            }
            finally {
                ((Writer)writer).close();
            }
            builder.addExtensions(new FeatureExtension[]{b3.build()});
        }
        Hashtable output = Configurations.newConfiguration();
        if (!feature.getFrameworkProperties().isEmpty()) {
            Hashtable fwkMetadata = Configurations.newConfiguration();
            for (String fwkPropName : feature.getFrameworkProperties().keySet()) {
                metadata = feature.getFrameworkPropertyMetadata(fwkPropName);
                if (metadata.isEmpty()) continue;
                fwkMetadata.put(fwkPropName, metadata);
            }
            if (!fwkMetadata.isEmpty()) {
                output.put(FRAMEWORK_PROPERTIES_METADATA, fwkMetadata);
            }
        }
        if (!feature.getVariables().isEmpty()) {
            Hashtable varMetadata = Configurations.newConfiguration();
            for (String varName : feature.getVariables().keySet()) {
                metadata = feature.getVariableMetadata(varName);
                if (metadata.isEmpty()) continue;
                varMetadata.put(varName, metadata);
            }
            if (!varMetadata.isEmpty()) {
                output.put(VARIABLES_METADATA, varMetadata);
            }
        }
        if (!output.isEmpty()) {
            FeatureExtensionBuilder b4 = service.getBuilderFactory().newExtensionBuilder("feature-internal-data", FeatureExtension.Type.JSON, FeatureExtension.Kind.OPTIONAL);
            writer = new StringWriter();
            try {
                Configurations.buildWriter().build((Writer)writer).writeConfiguration((Dictionary)output);
                ((Writer)writer).flush();
                b4.setJSON(writer.toString());
            }
            finally {
                ((Writer)writer).close();
            }
            builder.addExtensions(new FeatureExtension[]{b4.build()});
        }
        return builder.build();
    }

    public static Feature convert(org.osgi.service.feature.Feature feature) throws IOException {
        if (feature == null) {
            return null;
        }
        Feature f = new Feature(ArtifactId.parse(feature.getID().toString()));
        f.setComplete(feature.isComplete());
        f.setDescription(feature.getDescription().orElse(null));
        f.setLicense(feature.getLicense().orElse(null));
        f.setTitle(feature.getName().orElse(null));
        f.setVendor(feature.getVendor().orElse(null));
        f.setDocURL(feature.getDocURL().orElse(null));
        f.setSCMInfo(feature.getSCM().orElse(null));
        f.getCategories().addAll(feature.getCategories());
        feature.getVariables().entrySet().stream().forEach(entry -> f.getVariables().put((String)entry.getKey(), entry.getValue().toString()));
        for (FeatureBundle bundle : feature.getBundles()) {
            Artifact b = new Artifact(ArtifactId.parse(bundle.getID().toString()));
            bundle.getMetadata().entrySet().stream().forEach(entry -> b.getMetadata().put((String)entry.getKey(), entry.getValue().toString()));
            f.getBundles().add(b);
        }
        for (FeatureConfiguration cfg : feature.getConfigurations().values()) {
            Configuration c = new Configuration(cfg.getPid());
            cfg.getValues().entrySet().stream().forEach(entry -> c.getProperties().put((String)entry.getKey(), entry.getValue()));
            f.getConfigurations().add(c);
        }
        for (FeatureExtension ext : feature.getExtensions().values()) {
            StringReader reader;
            if (FRAMEWORK_PROPERTIES_EXTENSION.equals(ext.getName())) {
                reader = new StringReader(ext.getJSON());
                try {
                    Configurations.buildReader().build((Reader)reader).readConfiguration().entrySet().stream().forEach(entry -> f.getFrameworkProperties().put((String)entry.getKey(), entry.getValue().toString()));
                    continue;
                }
                finally {
                    ((Reader)reader).close();
                    continue;
                }
            }
            if ("feature-internal-data".equals(ext.getName())) {
                reader = new StringReader(ext.getJSON());
                try {
                    String fwkMetadata;
                    Hashtable md = Configurations.buildReader().build((Reader)reader).readConfiguration();
                    String varMetadata = (String)md.get(VARIABLES_METADATA);
                    if (varMetadata != null) {
                        try (StringReader r = new StringReader(varMetadata);){
                            for (Map.Entry entry2 : Configurations.buildReader().verifyAsBundleResource(true).build((Reader)r).readConfigurationResource().getConfigurations().entrySet()) {
                                f.getVariableMetadata((String)entry2.getKey()).putAll((Map)entry2.getValue());
                            }
                        }
                    }
                    if ((fwkMetadata = (String)md.get(FRAMEWORK_PROPERTIES_METADATA)) == null) continue;
                    StringReader r = new StringReader(fwkMetadata);
                    try {
                        for (Map.Entry entry3 : Configurations.buildReader().verifyAsBundleResource(true).build((Reader)r).readConfigurationResource().getConfigurations().entrySet()) {
                            f.getFrameworkPropertyMetadata((String)entry3.getKey()).putAll((Map)entry3.getValue());
                        }
                        continue;
                    }
                    finally {
                        r.close();
                        continue;
                    }
                }
                finally {
                    ((Reader)reader).close();
                    continue;
                }
            }
            ExtensionType type = ext.getType() == FeatureExtension.Type.ARTIFACTS ? ExtensionType.ARTIFACTS : (ext.getType() == FeatureExtension.Type.TEXT ? ExtensionType.TEXT : ExtensionType.JSON);
            ExtensionState state = ext.getKind() == FeatureExtension.Kind.OPTIONAL ? ExtensionState.OPTIONAL : (ext.getKind() == FeatureExtension.Kind.MANDATORY ? ExtensionState.REQUIRED : ExtensionState.TRANSIENT);
            Extension e = new Extension(type, ext.getName(), state);
            if (ext.getType() == FeatureExtension.Type.ARTIFACTS) {
                for (FeatureArtifact artifact : ext.getArtifacts()) {
                    Artifact artifact2 = new Artifact(ArtifactId.parse(artifact.getID().toString()));
                    artifact.getMetadata().entrySet().stream().forEach(entry -> a.getMetadata().put((String)entry.getKey(), entry.getValue().toString()));
                    e.getArtifacts().add(artifact2);
                }
            } else if (ext.getType() == FeatureExtension.Type.TEXT) {
                e.setText(String.join((CharSequence)"\n", ext.getText()));
            } else {
                e.setJSON(ext.getJSON());
            }
            f.getExtensions().add(e);
        }
        return f;
    }
}

