/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.guava.common.util.concurrent.UncheckedExecutionException;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriter;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriterPool;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.AbstractFileStore;
import org.apache.jackrabbit.oak.segment.file.CleanupFirstGarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.DefaultGarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.FileReaper;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.FileStoreStats;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.GarbageCollector;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;
import org.apache.jackrabbit.oak.segment.file.SafeRunnable;
import org.apache.jackrabbit.oak.segment.file.Scheduler;
import org.apache.jackrabbit.oak.segment.file.ShutDown;
import org.apache.jackrabbit.oak.segment.file.SynchronizedGarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.segment.file.UnrecoverableArchiveException;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.apache.jackrabbit.oak.segment.spi.RepositoryNotReachableException;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore
extends AbstractFileStore {
    private static final Logger log = LoggerFactory.getLogger(FileStore.class);
    private static final int MB = 0x100000;
    private static final String TAR_READER_COUNT = "TAR_READER_COUNT";
    private static final String SEGMENT_COUNT = "SEGMENT_COUNT";
    @NotNull
    private final SegmentWriter segmentWriter;
    @NotNull
    private final GarbageCollector garbageCollector;
    private final TarFiles tarFiles;
    private final RepositoryLock repositoryLock;
    private volatile TarRevisions revisions;
    private final Scheduler fileStoreScheduler = new Scheduler("FileStore background tasks");
    private final FileReaper fileReaper;
    private final AtomicBoolean sufficientDiskSpace = new AtomicBoolean(true);
    private final AtomicBoolean sufficientMemory = new AtomicBoolean(true);
    private final FileStoreStats stats;
    private final ShutDown shutDown = new ShutDown();
    @NotNull
    private final SegmentNotFoundExceptionListener snfeListener;
    private final GarbageCollectionStrategy garbageCollectionStrategy = FileStore.newGarbageCollectionStrategy();
    private final boolean eagerSegmentCaching;

    private static GarbageCollectionStrategy newGarbageCollectionStrategy() {
        if (Boolean.getBoolean("gc.classic")) {
            return new SynchronizedGarbageCollectionStrategy(new DefaultGarbageCollectionStrategy());
        }
        return new SynchronizedGarbageCollectionStrategy(new CleanupFirstGarbageCollectionStrategy());
    }

    FileStore(FileStoreBuilder builder) throws InvalidFileStoreVersionException, IOException {
        super(builder);
        SegmentNodeStorePersistence persistence = builder.getPersistence();
        this.repositoryLock = persistence.lockRepository();
        StatisticsProvider statsProvider = builder.getStatsProvider();
        this.segmentWriter = DefaultSegmentWriterBuilder.defaultSegmentWriterBuilder("sys").withGeneration((Supplier<GCGeneration>)((Supplier)() -> this.getGcGeneration().nonGC())).withWriterPool().with(builder.getCacheManager().withAccessTracking("WRITE", statsProvider)).build(this);
        FileStore.newManifestChecker(persistence, builder.getStrictVersionCheck()).checkAndUpdateManifest();
        this.stats = new FileStoreStats(statsProvider, this, 0L);
        CounterStats readerCountStats = statsProvider.getCounterStats(TAR_READER_COUNT, StatsOptions.DEFAULT);
        CounterStats segmentCountStats = statsProvider.getCounterStats(SEGMENT_COUNT, StatsOptions.DEFAULT);
        TarFiles.Builder tarFilesBuilder = TarFiles.builder().withDirectory(this.directory).withMemoryMapping(this.memoryMapping).withTarRecovery(this.recovery).withIOMonitor(this.ioMonitor).withRemoteStoreMonitor(this.remoteStoreMonitor).withFileStoreMonitor(this.stats).withMaxFileSize(builder.getMaxFileSize() * 0x100000).withPersistence(builder.getPersistence()).withReaderCountStats(readerCountStats).withSegmentCountStats(segmentCountStats);
        this.tarFiles = tarFilesBuilder.build();
        long size = this.tarFiles.size();
        this.stats.init(size);
        this.fileReaper = this.tarFiles.createFileReaper();
        this.garbageCollector = new GarbageCollector(builder.getGcOptions(), builder.getGcListener(), new GCJournal(persistence.getGCJournalFile()), this.sufficientMemory, this.fileReaper, this.tarFiles, this.tracker, this.segmentReader, (Supplier<Revisions>)((Supplier)() -> this.revisions), this.getBlobStore(), this.segmentCache, this.segmentWriter, this.stats, Canceller.newCanceller().withCondition("not enough disk space", () -> !this.sufficientDiskSpace.get()).withCondition("not enough memory", () -> !this.sufficientMemory.get()).withCondition("FileStore is shutting down", this.shutDown::isShutDown), this::flush, generation -> DefaultSegmentWriterBuilder.defaultSegmentWriterBuilder("c").with(builder.getCacheManager().withAccessTracking("COMPACT", statsProvider)).withGeneration(generation).withWriterPool(SegmentBufferWriterPool.PoolType.THREAD_SPECIFIC).build(this));
        this.snfeListener = builder.getSnfeListener();
        this.eagerSegmentCaching = builder.getEagerSegmentCaching();
        TimerStats flushTimer = statsProvider.getTimer("oak.segment.flush", StatsOptions.METRICS_ONLY);
        this.fileStoreScheduler.scheduleWithFixedDelay(String.format("TarMK flush [%s]", this.directory), 5L, TimeUnit.SECONDS, () -> {
            TimerStats.Context timer = flushTimer.time();
            try {
                this.tryFlush();
            }
            finally {
                timer.stop();
            }
        });
        this.fileStoreScheduler.scheduleWithFixedDelay(String.format("TarMK filer reaper [%s]", this.directory), 5L, TimeUnit.SECONDS, this.fileReaper::reap);
        this.fileStoreScheduler.scheduleWithFixedDelay(String.format("TarMK disk space check [%s]", this.directory), 1L, TimeUnit.MINUTES, () -> {
            try (ShutDown.ShutDownCloser ignore = this.shutDown.tryKeepAlive();){
                if (this.shutDown.isShutDown()) {
                    log.debug("Shut down in progress, skipping disk space check");
                } else {
                    this.checkDiskSpace(builder.getGcOptions());
                }
            }
        });
        log.info("TarMK opened at {}, mmap={}, offHeapAccess={}, size={}", new Object[]{this.directory, this.memoryMapping, this.offHeapAccess, PrintableBytes.newPrintableBytes(size)});
        log.debug("TAR files: {}", (Object)this.tarFiles);
    }

    FileStore bind(TarRevisions revisions) throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.revisions = revisions;
            this.revisions.bind(this, this.tracker, this.initialNode());
            FileStore fileStore = this;
            return fileStore;
        }
    }

    @NotNull
    private Supplier<RecordId> initialNode() {
        return new Supplier<RecordId>(){

            public RecordId get() {
                try {
                    DefaultSegmentWriter writer = DefaultSegmentWriterBuilder.defaultSegmentWriterBuilder("init").build(FileStore.this);
                    NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
                    builder.setChildNode("root", EmptyNodeState.EMPTY_NODE);
                    SegmentNodeState node = new SegmentNodeState(FileStore.this.segmentReader, writer, FileStore.this.getBlobStore(), writer.writeNode(builder.getNodeState()));
                    writer.flush();
                    return node.getRecordId();
                }
                catch (IOException e) {
                    String msg = "Failed to write initial node";
                    log.error(msg, (Throwable)e);
                    throw new IllegalStateException(msg, e);
                }
            }
        };
    }

    @NotNull
    private GCGeneration getGcGeneration() {
        return this.revisions.getHead().getSegmentId().getGcGeneration();
    }

    public Runnable getGCRunner() {
        return new SafeRunnable(String.format("TarMK revision gc [%s]", this.directory), () -> {
            try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
                this.garbageCollector.run(this.garbageCollectionStrategy);
            }
            catch (IOException e) {
                log.error("Error running revision garbage collection", (Throwable)e);
            }
        });
    }

    public GCNodeWriteMonitor getGCNodeWriteMonitor() {
        return this.garbageCollector.getGCNodeWriteMonitor();
    }

    private long size() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            long l = this.tarFiles.size();
            return l;
        }
    }

    public int readerCount() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            int n = this.tarFiles.readerCount();
            return n;
        }
    }

    public int getSegmentCount() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            int n = this.tarFiles.segmentCount();
            return n;
        }
    }

    public FileStoreStats getStats() {
        return this.stats;
    }

    private void doFlush() throws IOException {
        if (this.revisions == null) {
            log.debug("No TarRevisions available, skipping flush");
            return;
        }
        this.revisions.flush(() -> {
            this.segmentWriter.flush();
            this.tarFiles.flush();
            this.stats.flushed();
        });
    }

    public void flush() throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.doFlush();
        }
    }

    public void tryFlush() {
        try (ShutDown.ShutDownCloser ignore = this.shutDown.tryKeepAlive();){
            if (this.shutDown.isShutDown()) {
                log.debug("Shut down in progress, skipping flush");
            } else if (this.revisions == null) {
                log.debug("No TarRevisions available, skipping flush");
            } else {
                this.revisions.tryFlush(() -> {
                    this.segmentWriter.flush();
                    this.tarFiles.flush();
                    this.stats.flushed();
                });
            }
        }
        catch (UnrecoverableArchiveException e) {
            log.error("Critical failure while flushing pending changes. Shutting down the FileStore.", (Throwable)e);
            this.close();
        }
        catch (IOException e) {
            log.warn("Failed to flush the TarMK at {}", (Object)this.directory, (Object)e);
        }
    }

    public void fullGC() throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.garbageCollector.runFull(this.garbageCollectionStrategy);
        }
    }

    public void tailGC() throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.garbageCollector.runTail(this.garbageCollectionStrategy);
        }
    }

    public boolean compactFull() {
        ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();
        try {
            boolean bl = this.garbageCollector.compactFull(this.garbageCollectionStrategy).isSuccess();
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Unable to perform full compaction", (Throwable)e);
                return false;
            }
        }
    }

    public boolean compactTail() {
        ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();
        try {
            boolean bl = this.garbageCollector.compactTail(this.garbageCollectionStrategy).isSuccess();
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Unable to perform tail compaction");
                return false;
            }
        }
    }

    public void cleanup() throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.fileReaper.add(this.garbageCollector.cleanup(this.garbageCollectionStrategy));
        }
    }

    @Override
    public void collectBlobReferences(Consumer<String> collector) throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            this.garbageCollector.collectBlobReferences(collector);
        }
    }

    public void cancelGC() {
        this.garbageCollector.cancel();
    }

    @Override
    @NotNull
    public SegmentWriter getWriter() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            SegmentWriter segmentWriter = this.segmentWriter;
            return segmentWriter;
        }
    }

    @Override
    @NotNull
    public TarRevisions getRevisions() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            TarRevisions tarRevisions = this.revisions;
            return tarRevisions;
        }
    }

    @Override
    public void close() {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.shutDown();){
            this.fileStoreScheduler.close();
            try {
                this.doFlush();
            }
            catch (IOException e) {
                log.warn("Unable to flush the store", (Throwable)e);
            }
            Closer closer = Closer.create();
            closer.register(this.repositoryLock::unlock);
            closer.register((Closeable)this.tarFiles);
            closer.register((Closeable)this.revisions);
            FileStore.closeAndLogOnFail((Closeable)closer);
        }
        System.gc();
        this.fileReaper.reap();
        log.info("TarMK closed: {}", (Object)this.directory);
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            boolean bl = this.tarFiles.containsSegment(id.getMostSignificantBits(), id.getLeastSignificantBits());
            return bl;
        }
    }

    @Override
    @NotNull
    public Segment readSegment(SegmentId id) {
        ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();
        try {
            Segment segment = this.segmentCache.getSegment(id, () -> this.readSegmentUncached(this.tarFiles, id));
            if (ignored != null) {
                ignored.close();
            }
            return segment;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ExecutionException | UncheckedExecutionException e) {
                if (e.getCause() instanceof RepositoryNotReachableException) {
                    RepositoryNotReachableException re = (RepositoryNotReachableException)((Object)e.getCause());
                    log.warn("Unable to access repository", (Throwable)((Object)re));
                    throw re;
                }
                SegmentNotFoundException snfe = FileStore.asSegmentNotFoundException((Exception)e, id);
                this.snfeListener.notify(id, snfe);
                this.stats.notify(id, snfe);
                throw snfe;
            }
        }
    }

    @Override
    public void writeSegment(SegmentId id, byte[] buffer, int offset, int length) throws IOException {
        try (ShutDown.ShutDownCloser ignored = this.shutDown.keepAlive();){
            Segment segment = null;
            GCGeneration generation = GCGeneration.NULL;
            Set<UUID> references = null;
            Set<String> binaryReferences = null;
            if (id.isDataSegmentId()) {
                Buffer data;
                if (offset > 4096) {
                    data = Buffer.allocate((int)length);
                    data.put(buffer, offset, length);
                    data.rewind();
                } else {
                    data = Buffer.wrap((byte[])buffer, (int)offset, (int)length);
                }
                segment = new Segment(this.tracker, this.segmentReader, id, data);
                if (this.eagerSegmentCaching) {
                    this.segmentCache.putSegment(segment);
                }
                generation = segment.getGcGeneration();
                references = FileStore.readReferences(segment);
                binaryReferences = FileStore.readBinaryReferences(segment);
            }
            this.tarFiles.writeSegment(id.asUUID(), buffer, offset, length, generation, references, binaryReferences);
            if (!this.eagerSegmentCaching && segment != null) {
                this.segmentCache.putSegment(segment);
            }
        }
    }

    private void checkDiskSpace(SegmentGCOptions gcOptions) {
        long availableDiskSpace;
        long repositoryDiskSpace = this.size();
        boolean updated = SegmentGCOptions.isDiskSpaceSufficient(repositoryDiskSpace, availableDiskSpace = this.directory.getFreeSpace());
        boolean previous = this.sufficientDiskSpace.getAndSet(updated);
        if (previous && !updated) {
            log.warn("Available disk space ({}) is too low, current repository size is approx. {}", (Object)IOUtils.humanReadableByteCount((long)availableDiskSpace), (Object)IOUtils.humanReadableByteCount((long)repositoryDiskSpace));
        }
        if (updated && !previous) {
            log.info("Available disk space ({}) is sufficient again for repository operations, current repository size is approx. {}", (Object)IOUtils.humanReadableByteCount((long)availableDiskSpace), (Object)IOUtils.humanReadableByteCount((long)repositoryDiskSpace));
        }
    }
}

