/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.segment.ApproximateCounter;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.CheckpointCompactor;
import org.apache.jackrabbit.oak.segment.CompactorUtils;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParallelCompactor
extends CheckpointCompactor {
    private static final int MIN_NODES_PER_WORKER = 1000;
    private static final int MAX_NODES_PER_WORKER = 10000;
    private final int numWorkers;
    private final long totalSizeEstimate;
    @Nullable
    private ExecutorService executorService;

    public ParallelCompactor(@NotNull GCMonitor gcListener, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore, @NotNull GCNodeWriteMonitor compactionMonitor, int nThreads) {
        super(gcListener, reader, writer, blobStore, compactionMonitor);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (nThreads < 0) {
            nThreads += availableProcessors + 1;
        }
        this.numWorkers = Math.max(0, nThreads - 1);
        this.totalSizeEstimate = compactionMonitor.getEstimatedTotal();
    }

    private int getMinNodeCount() {
        return this.numWorkers * 1000;
    }

    private int getMaxNodeCount() {
        return this.numWorkers * 10000;
    }

    @Override
    @Nullable
    protected SegmentNodeState compactWithDelegate(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, Canceller canceller) throws IOException {
        if (this.numWorkers <= 0) {
            this.gcListener.info("using sequential compaction.", new Object[0]);
            return super.compactWithDelegate(before, after, onto, canceller);
        }
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newFixedThreadPool(this.numWorkers);
        }
        return new CompactionHandler(onto, canceller).diff(before, after);
    }

    private class CompactionHandler {
        @NotNull
        private final NodeState base;
        @NotNull
        private final Canceller canceller;

        CompactionHandler(@NotNull NodeState base, Canceller canceller) {
            this.base = base;
            this.canceller = canceller;
        }

        @Nullable
        SegmentNodeState diff(@NotNull NodeState before, @NotNull NodeState after) throws IOException {
            SegmentNodeState compacted;
            Preconditions.checkNotNull((Object)ParallelCompactor.this.executorService);
            Preconditions.checkState((!ParallelCompactor.this.executorService.isShutdown() ? 1 : 0) != 0);
            ParallelCompactor.this.gcListener.info("compacting with {} threads.", new Object[]{ParallelCompactor.this.numWorkers + 1});
            ParallelCompactor.this.gcListener.info("exploring content tree to find subtrees for parallel compaction.", new Object[0]);
            ParallelCompactor.this.gcListener.info("target node count for expansion is {}, based on {} available workers.", new Object[]{ParallelCompactor.this.getMinNodeCount(), ParallelCompactor.this.numWorkers});
            CompactionTree compactionTree = new CompactionTree(before, after, this.base);
            if (!compactionTree.compareStates(this.canceller)) {
                return null;
            }
            ArrayList<CompactionTree> topLevel = new ArrayList<CompactionTree>();
            block10: for (Map.Entry<String, CompactionTree> childEntry : compactionTree.modifiedChildren.entrySet()) {
                switch (childEntry.getKey()) {
                    case "content": 
                    case "oak:index": 
                    case "jcr:system": {
                        topLevel.add(childEntry.getValue());
                        continue block10;
                    }
                }
                Preconditions.checkState((boolean)childEntry.getValue().compactAsync(this.canceller));
            }
            if (this.diff(1, topLevel) && (compacted = compactionTree.compact()) != null) {
                return compacted;
            }
            try {
                ParallelCompactor.this.executorService.shutdown();
                if (!ParallelCompactor.this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    ParallelCompactor.this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                ParallelCompactor.this.executorService.shutdownNow();
            }
            return null;
        }

        private boolean diff(int depth, List<CompactionTree> nodes) {
            int targetCount = ParallelCompactor.this.getMinNodeCount();
            ParallelCompactor.this.gcListener.info("Found {} nodes at depth {}, target is {}.", new Object[]{nodes.size(), depth, targetCount});
            if (nodes.size() >= targetCount) {
                nodes.forEach(node -> node.compactAsync(this.canceller));
                return true;
            }
            if (nodes.isEmpty()) {
                ParallelCompactor.this.gcListener.info("Amount of changes too small, tree will not be split.", new Object[0]);
                return true;
            }
            ArrayList<CompactionTree> nextDepth = new ArrayList<CompactionTree>();
            for (CompactionTree node2 : nodes) {
                long estimatedSize = node2.getEstimatedSize();
                if (estimatedSize != -1L && estimatedSize <= ParallelCompactor.this.totalSizeEstimate / (long)ParallelCompactor.this.numWorkers) {
                    Preconditions.checkState((boolean)node2.compactAsync(this.canceller));
                    continue;
                }
                if (nextDepth.size() < ParallelCompactor.this.getMaxNodeCount()) {
                    if (!node2.compareStates(this.canceller)) {
                        return false;
                    }
                    nextDepth.addAll(node2.modifiedChildren.values());
                    continue;
                }
                nextDepth.add(node2);
            }
            return this.diff(depth + 1, nextDepth);
        }
    }

    private class CompactionTree
    implements NodeStateDiff {
        @NotNull
        private final NodeState before;
        @NotNull
        private final NodeState after;
        @NotNull
        private final NodeState onto;
        @NotNull
        private final HashMap<String, CompactionTree> modifiedChildren = new HashMap();
        @NotNull
        private final List<Property> modifiedProperties = new ArrayList<Property>();
        @NotNull
        private final List<String> removedChildNames = new ArrayList<String>();
        @NotNull
        private final List<String> removedPropertyNames = new ArrayList<String>();
        @Nullable
        private Future<SegmentNodeState> compactionFuture;

        CompactionTree(@NotNull NodeState before, @NotNull NodeState after, NodeState onto) {
            this.before = (NodeState)Preconditions.checkNotNull((Object)before);
            this.after = (NodeState)Preconditions.checkNotNull((Object)after);
            this.onto = (NodeState)Preconditions.checkNotNull((Object)onto);
        }

        boolean compareStates(Canceller canceller) {
            return this.after.compareAgainstBaseState(this.before, (NodeStateDiff)new CancelableDiff(this, (Supplier<Boolean>)((Supplier)() -> canceller.check().isCancelled())));
        }

        long getEstimatedSize() {
            return ApproximateCounter.getCountSync(this.after);
        }

        public boolean propertyAdded(PropertyState after) {
            this.modifiedProperties.add(new Property(after));
            return true;
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            this.modifiedProperties.add(new Property(after));
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            this.removedPropertyNames.add(before.getName());
            return true;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            CompactionTree child = new CompactionTree(EmptyNodeState.EMPTY_NODE, after, EmptyNodeState.EMPTY_NODE);
            this.modifiedChildren.put(name, child);
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            CompactionTree child = new CompactionTree(before, after, this.onto.getChildNode(name));
            this.modifiedChildren.put(name, child);
            return true;
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            this.removedChildNames.add(name);
            return true;
        }

        boolean compactAsync(Canceller canceller) {
            if (this.compactionFuture != null) {
                return false;
            }
            Preconditions.checkNotNull((Object)ParallelCompactor.this.executorService);
            this.compactionFuture = ParallelCompactor.this.executorService.submit(() -> ParallelCompactor.this.compactor.compact(this.before, this.after, this.onto, canceller));
            return true;
        }

        @Nullable
        SegmentNodeState compact() throws IOException {
            if (this.compactionFuture != null) {
                try {
                    return this.compactionFuture.get();
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }
            MemoryNodeBuilder builder = new MemoryNodeBuilder(this.onto);
            for (Map.Entry<String, CompactionTree> entry : this.modifiedChildren.entrySet()) {
                SegmentNodeState compactedState = entry.getValue().compact();
                if (compactedState == null) {
                    return null;
                }
                builder.setChildNode(entry.getKey(), (NodeState)compactedState);
            }
            for (String childName : this.removedChildNames) {
                builder.getChildNode(childName).remove();
            }
            for (Property property : this.modifiedProperties) {
                builder.setProperty(property.compact());
            }
            for (String propertyName : this.removedPropertyNames) {
                builder.removeProperty(propertyName);
            }
            return ParallelCompactor.this.compactor.writeNodeState(builder.getNodeState(), CompactorUtils.getStableIdBytes(this.after));
        }

        private class Property {
            @NotNull
            private final PropertyState state;

            Property(PropertyState state) {
                this.state = state;
            }

            @NotNull
            PropertyState compact() {
                return ParallelCompactor.this.compactor.compact(this.state);
            }
        }
    }
}

