/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ElementPlugin
extends AbstractPlugin {
    public static final Set<ExpressionNode> VOID_ELEMENTS = Collections.unmodifiableSet(new HashSet<StringConstant>(Arrays.asList(new StringConstant("area"), new StringConstant("base"), new StringConstant("br"), new StringConstant("col"), new StringConstant("embed"), new StringConstant("hr"), new StringConstant("img"), new StringConstant("input"), new StringConstant("link"), new StringConstant("meta"), new StringConstant("param"), new StringConstant("source"), new StringConstant("track"), new StringConstant("wbr"))));

    public ElementPlugin() {
        this.name = "element";
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private final ExpressionNode node;
            private final String tagVar;
            private final String tagAllowed;
            private final String voidElements;
            private final String selfClosingTag;
            {
                this.node = ElementPlugin.this.adjustContext(compilerContext, expression).getRoot();
                this.tagVar = compilerContext.generateVariable("tagVar");
                this.tagAllowed = compilerContext.generateVariable("tagAllowed");
                this.voidElements = compilerContext.generateGlobalVariable("elementPluginVoidElements");
                this.selfClosingTag = compilerContext.generateVariable("selfClosingTag");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.write(new VariableBinding.Global(this.voidElements, new ArrayLiteral(new ArrayList<ExpressionNode>(VOID_ELEMENTS))));
                stream.write(new VariableBinding.Start(this.tagVar, this.node));
                stream.write(new VariableBinding.Start(this.tagAllowed, new UnaryOperation(UnaryOperator.NOT, new UnaryOperation(UnaryOperator.NOT, new Identifier(this.tagVar)))));
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                stream.write(new Conditional.Start(this.tagAllowed, true));
                stream.write(new OutText("<"));
                stream.write(new OutputVariable(this.tagVar));
                stream.write(Conditional.END);
                stream.write(new Conditional.Start(this.tagAllowed, false));
            }

            @Override
            public void beforeAttributes(PushStream stream) {
                stream.write(Conditional.END);
            }

            @Override
            public void afterAttributes(PushStream stream) {
                stream.write(new Conditional.Start(this.tagAllowed, true));
                stream.write(new OutText(">"));
                stream.write(Conditional.END);
                stream.write(new Conditional.Start(this.tagAllowed, false));
            }

            @Override
            public void afterTagOpen(PushStream stream) {
                stream.write(Conditional.END);
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                stream.write(new Conditional.Start(this.tagAllowed, true));
                stream.write(new VariableBinding.Start(this.selfClosingTag, new BinaryOperation(BinaryOperator.IN, new Identifier(this.tagVar), new Identifier(this.voidElements))));
                stream.write(new Conditional.Start(this.selfClosingTag, false));
                stream.write(new OutText("</"));
                stream.write(new OutputVariable(this.tagVar));
                stream.write(new OutText(">"));
                stream.write(Conditional.END);
                stream.write(VariableBinding.END);
                stream.write(Conditional.END);
                stream.write(new Conditional.Start(this.tagAllowed, false));
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.write(Conditional.END);
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(VariableBinding.END);
                stream.write(VariableBinding.END);
            }
        };
    }

    private Expression adjustContext(CompilerContext compilerContext, Expression expression) {
        RuntimeCall runtimeCall;
        ExpressionNode root = expression.getRoot();
        if (root instanceof RuntimeCall && (runtimeCall = (RuntimeCall)root).getFunctionName().equals("xss")) {
            return expression;
        }
        return compilerContext.adjustToContext(expression, MarkupContext.ELEMENT_NAME, ExpressionContext.ELEMENT);
    }
}

