/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.Arrays;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.internal.CommonUtils;
import org.apache.sling.cms.core.internal.models.ReferenceOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SlingPostProcessor.class}, property={"service.ranking=-1"})
public class UpdateReferencesPostOperation
implements SlingPostProcessor {
    public static final String RP_UPDATE_REFERENCES = ":updateReferences";
    private static final Logger log = LoggerFactory.getLogger(UpdateReferencesPostOperation.class);

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (("delete".equals(request.getParameter(":operation")) || "move".equals(request.getParameter(":operation"))) && "true".equalsIgnoreCase(request.getParameter(RP_UPDATE_REFERENCES))) {
            this.updateReferences(request, changes);
        }
    }

    private void updateReferences(SlingHttpServletRequest request, final List<Modification> changes) {
        final String find = request.getResource().getPath();
        final String destination = request.getParameter(":dest");
        if (log.isDebugEnabled()) {
            log.debug("Using destination: {}", (Object)CommonUtils.escapeLogMessage(destination));
        }
        ReferenceOperation ro = new ReferenceOperation(request.getResource()){

            @Override
            public void doProcess(Resource resource, String matchingKey) {
                ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                log.trace("Updating references in property {}@{}", (Object)resource.getPath(), (Object)matchingKey);
                if (properties != null) {
                    if (properties.get((Object)matchingKey) instanceof String) {
                        String value = ((String)properties.get(matchingKey, (Object)"")).replace(find, destination);
                        properties.put((Object)matchingKey, (Object)value);
                        log.trace("Updated value {}", (Object)value);
                    } else if (properties.get((Object)matchingKey) instanceof String[]) {
                        Object[] values = (String[])properties.get(matchingKey, (Object)new String[0]);
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = values[i].replace(find, destination);
                        }
                        properties.put((Object)matchingKey, (Object)values);
                        if (log.isTraceEnabled()) {
                            log.trace("Updated values {}", (Object)Arrays.toString(values));
                        }
                    }
                } else {
                    log.warn("Unable to update references in {}, unable to edit", (Object)resource);
                }
                changes.add(Modification.onModified((String)resource.getPath()));
            }
        };
        ro.init();
    }
}

