/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.AbstractAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicyBuilder;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.ResourceBasedAccessControlEntry;

public class ResourceBasedAccessControlList
extends JackrabbitAccessControlPolicy {
    private final List<ResourceBasedAccessControlEntry> entries = new ArrayList<ResourceBasedAccessControlEntry>();

    ResourceBasedAccessControlList(List<ResourceBasedAccessControlEntry> aceList) {
        this.entries.addAll(aceList);
    }

    @Override
    public List<String> apply(Session session, AccessControlHandling aclHandling, String accessControlledPath) throws RepositoryException {
        if (aclHandling == AccessControlHandling.IGNORE) {
            return Collections.emptyList();
        }
        JackrabbitAccessControlManager acMgr = ResourceBasedAccessControlList.getAccessControlManager(session);
        JackrabbitAccessControlList acl = this.getPolicy(acMgr, JackrabbitAccessControlList.class, accessControlledPath);
        HashSet<String> existingPrincipals = new HashSet<String>();
        if (acl != null) {
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                existingPrincipals.add(ace.getPrincipal().getName());
            }
            if (aclHandling == AccessControlHandling.OVERWRITE) {
                acMgr.removePolicy(accessControlledPath, (AccessControlPolicy)acl);
                acl = null;
            }
        }
        if (acl == null) {
            acl = this.getApplicablePolicy(acMgr, JackrabbitAccessControlList.class, accessControlledPath);
        }
        if (aclHandling == AccessControlHandling.MERGE) {
            for (ResourceBasedAccessControlEntry entry : this.entries) {
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    if (!ace.getPrincipal().getName().equals(entry.principalName)) continue;
                    acl.removeAccessControlEntry(ace);
                }
            }
        }
        for (ResourceBasedAccessControlEntry ace : this.entries) {
            String principalName = ace.principalName;
            if (aclHandling == AccessControlHandling.MERGE_PRESERVE && existingPrincipals.contains(principalName)) continue;
            Principal principal = this.getPrincipal(principalName);
            Map.Entry<Map<String, Value>, Map<String, Value[]>> restrictions = ace.separateRestrictions(acl);
            acl.addEntry(principal, ace.getPrivileges((AccessControlManager)acMgr), ace.allow, restrictions.getKey(), restrictions.getValue());
        }
        acMgr.setPolicy(accessControlledPath, (AccessControlPolicy)acl);
        String path = accessControlledPath == null ? "/rep:repoPolicy" : ("/".equals(accessControlledPath) ? "/rep:policy" : accessControlledPath + "/" + "rep:policy");
        return Collections.singletonList(path);
    }

    public static final class Builder
    implements JackrabbitAccessControlPolicyBuilder<ResourceBasedAccessControlList> {
        private final List<ResourceBasedAccessControlEntry> entries = new ArrayList<ResourceBasedAccessControlEntry>();

        @Override
        public void addEntry(AbstractAccessControlEntry entry) {
            if (!(entry instanceof ResourceBasedAccessControlEntry)) {
                throw new IllegalStateException("Only entries of type ResourceBasedAccessControlEntry are supported");
            }
            this.entries.add((ResourceBasedAccessControlEntry)entry);
        }

        @Override
        public ResourceBasedAccessControlList build() {
            return new ResourceBasedAccessControlList(this.entries);
        }
    }
}

