/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.util.Collection;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.AbstractAccessControlEntry;

public class ResourceBasedAccessControlEntry
extends AbstractAccessControlEntry {
    final boolean allow;
    final String principalName;

    public ResourceBasedAccessControlEntry(JackrabbitAccessControlEntry entry) throws RepositoryException {
        super(entry);
        this.allow = entry.isAllow();
        this.principalName = entry.getPrincipal().getName();
    }

    protected ResourceBasedAccessControlEntry(boolean allow, String principalName, Collection<String> privileges, Map<String, Value[]> restrictions) {
        super(privileges, restrictions);
        this.allow = allow;
        this.principalName = principalName;
    }

    public static class Builder
    extends AbstractAccessControlEntry.Builder<ResourceBasedAccessControlEntry> {
        final boolean allow;
        final String principalName;

        public Builder(Collection<String> privileges, boolean allow, String principalName) {
            super(privileges);
            this.allow = allow;
            this.principalName = principalName;
        }

        @Override
        public ResourceBasedAccessControlEntry build() {
            return new ResourceBasedAccessControlEntry(this.allow, this.principalName, this.privileges, this.restrictions);
        }
    }
}

