/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.authorization.PrincipalSetPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.SimplePrincipal;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicyBuilder;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalBasedAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalBasedAccessControlList;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.PrincipalSetAccessControlPolicy;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.ResourceBasedAccessControlEntry;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.ResourceBasedAccessControlList;
import org.apache.jackrabbit.vault.util.UncheckedRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JackrabbitAccessControlPolicy {
    protected static final Logger log = LoggerFactory.getLogger(JackrabbitAccessControlPolicy.class);

    public static JackrabbitAccessControlPolicy fromAccessControlPolicy(AccessControlPolicy policy) throws RepositoryException {
        JackrabbitAccessControlPolicyBuilder<PrincipalBasedAccessControlList> builder;
        if (policy instanceof PrincipalAccessControlList) {
            PrincipalAccessControlList principalAcl = (PrincipalAccessControlList)policy;
            builder = new PrincipalBasedAccessControlList.Builder(principalAcl.getPrincipal().getName());
            Arrays.stream(principalAcl.getAccessControlEntries()).map(PrincipalAccessControlList.Entry.class::cast).map(t -> {
                try {
                    return new PrincipalBasedAccessControlEntry((PrincipalAccessControlList.Entry)t);
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(e);
                }
            }).forEach(builder::addEntry);
        } else if (policy instanceof PrincipalSetPolicy) {
            PrincipalSetPolicy principalSetPolicy = (PrincipalSetPolicy)policy;
            builder = new PrincipalSetAccessControlPolicy.Builder(principalSetPolicy.getPrincipals().stream().map(Principal::getName).collect(Collectors.toList()));
        } else if (policy instanceof JackrabbitAccessControlList) {
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
            builder = new ResourceBasedAccessControlList.Builder();
            Arrays.stream(acl.getAccessControlEntries()).map(JackrabbitAccessControlEntry.class::cast).map(t -> {
                try {
                    return new ResourceBasedAccessControlEntry((JackrabbitAccessControlEntry)t);
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(e);
                }
            }).forEach(builder::addEntry);
        } else {
            throw new RepositoryException("Unsupported policy type " + policy);
        }
        return builder.build();
    }

    JackrabbitAccessControlPolicy() {
    }

    Principal getPrincipal(Session session, String principalName, String accessControlledPath) throws RepositoryException {
        PrincipalManager pMgr = JackrabbitAccessControlPolicy.getPrincipalManager(session);
        Principal p = pMgr.getPrincipal(principalName);
        if (p == null) {
            try {
                Authorizable a = JackrabbitAccessControlPolicy.getUserManager(session).getAuthorizableByPath(accessControlledPath);
                if (a != null) {
                    p = a.getPrincipal();
                }
            }
            catch (RepositoryException e) {
                log.debug("Error while trying to retrieve user/group from access controlled path {}, {}", (Object)accessControlledPath, (Object)e.getMessage());
            }
            if (p == null) {
                p = this.getPrincipal(principalName);
            }
        }
        return p;
    }

    Principal getPrincipal(String principalName) {
        return new SimplePrincipal(principalName);
    }

    protected static final JackrabbitAccessControlManager getAccessControlManager(Session session) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        if (!(acMgr instanceof JackrabbitAccessControlManager)) {
            throw new IllegalStateException("The access control manager exposed by the given session is no JackrabbitAccessControlManager");
        }
        return (JackrabbitAccessControlManager)acMgr;
    }

    protected static final PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new IllegalStateException("This session is not a JackrabbitSession");
        }
        return ((JackrabbitSession)session).getPrincipalManager();
    }

    protected static final UserManager getUserManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new IllegalStateException("This session is not a JackrabbitSession");
        }
        return ((JackrabbitSession)session).getUserManager();
    }

    <T> T getPolicy(JackrabbitAccessControlManager acMgr, Class<T> clz, String accessControlledPath) throws RepositoryException {
        for (AccessControlPolicy p : acMgr.getPolicies(accessControlledPath)) {
            if (!clz.isAssignableFrom(p.getClass())) continue;
            return clz.cast(p);
        }
        return null;
    }

    <T> T getPolicy(JackrabbitAccessControlManager acMgr, Class<T> clz, Principal principal) throws RepositoryException {
        for (org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy p : acMgr.getPolicies(principal)) {
            if (!clz.isAssignableFrom(p.getClass())) continue;
            return clz.cast(p);
        }
        return null;
    }

    <T> T getApplicablePolicy(JackrabbitAccessControlManager acMgr, Class<T> clz, String accessControlledPath) throws RepositoryException {
        AccessControlPolicyIterator iter = acMgr.getApplicablePolicies(accessControlledPath);
        while (iter.hasNext()) {
            AccessControlPolicy p = iter.nextAccessControlPolicy();
            if (!clz.isAssignableFrom(p.getClass())) continue;
            return clz.cast(p);
        }
        throw new RepositoryException("no applicable AccessControlPolicy of type " + clz + " on " + (accessControlledPath == null ? "'root'" : accessControlledPath));
    }

    <T> T getApplicablePolicy(JackrabbitAccessControlManager acMgr, Class<T> clz, Principal principal) throws RepositoryException {
        for (org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy p : acMgr.getApplicablePolicies(principal)) {
            if (!clz.isAssignableFrom(p.getClass())) continue;
            return clz.cast(p);
        }
        throw new AccessControlException("no applicable AccessControlPolicy of type " + clz + " for " + principal.getName());
    }

    public abstract List<String> apply(Session var1, AccessControlHandling var2, String var3) throws RepositoryException;
}

