/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitUserManagement
implements UserManagement {
    public static final Name NAME_REP_AUTHORIZABLE_ID = NameFactoryImpl.getInstance().create("internal", "authorizableId");
    private static final Logger log = LoggerFactory.getLogger(JackrabbitUserManagement.class);

    @Override
    public boolean isAuthorizableNodeType(String ntName) {
        return ntName.equals("rep:Group") || ntName.equals("rep:User") || ntName.equals("rep:SystemUser");
    }

    @Override
    public String getAuthorizablePath(Session session, String id) {
        try {
            Authorizable authorizable = this.getAuthorizable(session, id);
            if (authorizable == null) {
                log.debug("No existing authorizable with id {} found", (Object)id);
                return null;
            }
            return authorizable.getPath();
        }
        catch (RepositoryException e) {
            log.warn("Unable to get authorizable path of {}: {}", new Object[]{id, e.getMessage(), e});
            return null;
        }
    }

    @Override
    @Deprecated
    public String getAuthorizableId(DocViewNode node) {
        DocViewProperty idProp = node.props.get("rep:authorizableId");
        if (idProp == null || idProp.isMulti) {
            return Text.unescapeIllegalJcrChars((String)node.name);
        }
        return idProp.values[0];
    }

    @Override
    public String getAuthorizableId(DocViewNode2 node) {
        DocViewProperty2 idProp = node.getProperty(NAME_REP_AUTHORIZABLE_ID).orElse(null);
        if (idProp == null || idProp.isMultiValue()) {
            return Text.unescapeIllegalJcrChars((String)node.getName().getLocalName());
        }
        return idProp.getStringValue().orElseThrow(() -> new IllegalStateException("No single value available for property 'rep:authorizableId'"));
    }

    @Override
    public void addMembers(Session session, String id, String[] membersUUID) {
        Authorizable auth;
        UserManager uMgr;
        try {
            uMgr = this.getUserManager(session);
            auth = uMgr.getAuthorizable(id);
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving authorizable.", (Object)id, (Object)e);
            return;
        }
        if (auth == null) {
            log.warn("Unable to update membership of {}. No such authorizable.", (Object)id);
            return;
        }
        if (!(auth instanceof Group)) {
            log.warn("Unable to update membership of {}. No a group.", (Object)id);
            return;
        }
        Group grp = (Group)auth;
        for (String uuid : membersUUID) {
            try {
                Node authNode = session.getNodeByIdentifier(uuid);
                String authPath = authNode.getPath();
                Authorizable member = uMgr.getAuthorizableByPath(authPath);
                if (member == null) {
                    log.warn("unable to add authorizable '{}' to group '{}'. Node at {} is not an authorizable.", (Object)uuid, (Object)authPath);
                    continue;
                }
                String memberId = member.getID();
                try {
                    if (grp.isDeclaredMember(member)) {
                        log.debug("ignoring to add authorizable '{}' to group '{}'. Already member.", (Object)memberId, (Object)id);
                        continue;
                    }
                    grp.addMember(member);
                    log.debug("added authorizable '{}' to group '{}'.", (Object)memberId, (Object)id);
                }
                catch (RepositoryException e) {
                    log.error("Error while adding authorizable '{}' to group '{}': {}", new Object[]{memberId, id, e});
                }
            }
            catch (ItemNotFoundException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. No such node.", (Object)uuid, (Object)id);
            }
            catch (RepositoryException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. Internal Error: {}", new Object[]{uuid, id, e});
            }
        }
    }

    private UserManager getUserManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("no jackrabbit session.");
        }
        return ((JackrabbitSession)session).getUserManager();
    }

    private Authorizable getAuthorizable(Session session, String id) throws RepositoryException {
        return this.getUserManager(session).getAuthorizable(id);
    }

    @Override
    public String getPrincipalName(Session session, String id) {
        try {
            Authorizable auth = this.getAuthorizable(session, id);
            if (auth != null) {
                return auth.getPrincipal().getName();
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to get principal name of {}. Error while retrieving user manager or authorizable.", (Object)id, (Object)e);
            return null;
        }
        return null;
    }
}

