/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.io.Writer;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.CNDWriter;
import org.apache.jackrabbit.vault.fs.spi.DefaultNodeTypes;
import org.apache.jackrabbit.vault.fs.spi.JcrVersion;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeInstaller;
import org.apache.jackrabbit.vault.fs.spi.ServiceProvider;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.DefaultCNDReader;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.DefaultCNDWriter;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitACLManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitPrivilegeInstaller;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitUserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrNodeTypeInstaller;

public class JackrabbitServiceProvider
implements ServiceProvider {
    private ACLManagement aclManagement;
    private UserManagement userManagement;

    @Override
    public JcrVersion getJCRVersion() {
        return JcrVersion.V20;
    }

    @Override
    public Set<String> getBuiltInNodeTypeNames() {
        return DefaultNodeTypes.CRX_2X_NODE_TYPES;
    }

    @Override
    public NodeTypeInstaller getDefaultNodeTypeInstaller(Session session) {
        return new JcrNodeTypeInstaller(session);
    }

    @Override
    public PrivilegeInstaller getDefaultPrivilegeInstaller(Session session) {
        return new JackrabbitPrivilegeInstaller(session);
    }

    @Override
    public CNDReader getCNDReader() {
        return new DefaultCNDReader();
    }

    @Override
    public CNDWriter getCNDWriter(Writer out, Session s, boolean includeNS) {
        return new DefaultCNDWriter(out, s, includeNS);
    }

    @Override
    public ACLManagement getACLManagement() {
        if (this.aclManagement == null) {
            this.aclManagement = new JackrabbitACLManagement();
        }
        return this.aclManagement;
    }

    @Override
    public UserManagement getUserManagement() {
        if (this.userManagement == null) {
            this.userManagement = new JackrabbitUserManagement();
        }
        return this.userManagement;
    }
}

