/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.impl.io.AggregateWalkListener;
import org.apache.jackrabbit.vault.util.DocViewNode2;

public class DocViewSAXFormatter
implements AggregateWalkListener {
    public static final String CDATA_TYPE = "CDATA";
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final XMLStreamWriter writer;
    protected final String jcrPrimaryType;
    protected final String ntUnstructured;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    private final List<Property> props = new ArrayList<Property>();
    private final Aggregate aggregate;
    private final boolean useBinaryReferences;
    private static final Set<String> IGNORED_POTENTIALLY_PROTECTED_PROPERTIES;

    protected DocViewSAXFormatter(Aggregate aggregate, XMLStreamWriter writer) throws RepositoryException {
        this.aggregate = aggregate;
        this.session = aggregate.getNode().getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.writer = writer;
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.nsResolver);
        try {
            this.jcrPrimaryType = npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            this.jcrMixinTypes = npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            this.jcrUUID = npResolver.getJCRName(NameConstants.JCR_UUID);
            this.jcrRoot = npResolver.getJCRName(NameConstants.JCR_ROOT);
            this.ntUnstructured = npResolver.getJCRName(NameConstants.NT_UNSTRUCTURED);
        }
        catch (NamespaceException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.useBinaryReferences = "true".equals(aggregate.getManager().getConfig().getProperty("useBinaryReferences"));
    }

    @Override
    public void onWalkBegin(Node root) throws RepositoryException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void onWalkEnd(Node root) throws RepositoryException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void onNodeBegin(Node node, boolean included, int level) throws RepositoryException {
        this.aggregate.getManager().addNodeTypes(node);
        this.props.clear();
    }

    @Override
    public void onChildren(Node node, int level) throws RepositoryException {
        try {
            Set<String> namespacePrefixes;
            DocViewNode2 docViewNode = DocViewNode2.fromNode(node, level == 0, this.props, this.useBinaryReferences);
            if (level == 0) {
                namespacePrefixes = new LinkedHashSet();
                namespacePrefixes.add("jcr");
                namespacePrefixes.addAll(Arrays.asList(this.aggregate.getNamespacePrefixes()));
            } else {
                namespacePrefixes = Collections.emptySet();
            }
            docViewNode.writeStart(this.writer, this.nsResolver, namespacePrefixes);
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void onNodeEnd(Node node, boolean included, int level) throws RepositoryException {
        try {
            DocViewNode2.writeEnd(this.writer);
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void onProperty(Property prop, int level) throws RepositoryException {
        if (IGNORED_POTENTIALLY_PROTECTED_PROPERTIES.contains(prop.getName()) && prop.getDefinition().isProtected()) {
            return;
        }
        this.props.add(prop);
    }

    @Override
    public void onNodeIgnored(Node node, int depth) throws RepositoryException {
        try {
            DocViewNode2 docViewNode = DocViewNode2.fromNode(node, false, Collections.emptyList(), this.useBinaryReferences);
            docViewNode.writeStart(this.writer, this.nsResolver, Collections.emptyList());
            DocViewNode2.writeEnd(this.writer);
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    static {
        HashSet<String> props = new HashSet<String>();
        props.add("jcr:created");
        props.add("jcr:createdBy");
        props.add("jcr:baseVersion");
        props.add("jcr:versionHistory");
        props.add("jcr:predecessors");
        IGNORED_POTENTIALLY_PROTECTED_PROPERTIES = Collections.unmodifiableSet(props);
    }
}

