/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCache
implements ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCache.class);
    private final BundleContext bundleContext;
    private final ConcurrentHashMap<String, SortedSet<Reference>> cache = new ConcurrentHashMap();

    public ServiceCache(BundleContext ctx) {
        this.bundleContext = ctx;
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void dispose() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        for (SortedSet<Reference> references : this.cache.values()) {
            for (Reference reference : references) {
                this.bundleContext.ungetService(reference.getServiceReference());
            }
        }
        this.cache.clear();
    }

    @Nullable
    public <ServiceType> ServiceType getService(Class<ServiceType> type) {
        SortedSet<Reference> references = this.getCachedReferences(type);
        for (Reference reference : references) {
            Object service = reference.getService();
            if (service == null) continue;
            return (ServiceType)service;
        }
        return null;
    }

    @Nullable
    public <ServiceType> ServiceType[] getServices(Class<ServiceType> type, String filter) {
        ArrayList<Object> result;
        block6: {
            result = new ArrayList<Object>();
            try {
                SortedSet<Reference> cachedReferences = this.getCachedReferences(type);
                Collection filteredReferences = this.bundleContext.getServiceReferences(type, filter);
                if (filteredReferences.isEmpty()) break block6;
                ArrayList localFilteredReferences = new ArrayList(filteredReferences);
                Collections.sort(localFilteredReferences);
                Collections.reverse(localFilteredReferences);
                block2: for (ServiceReference serviceReference : localFilteredReferences) {
                    Reference lookup = new Reference(serviceReference);
                    if (cachedReferences.contains(lookup)) {
                        for (Reference reference : cachedReferences) {
                            if (!serviceReference.equals(reference.getServiceReference())) continue;
                            Object service = reference.getService();
                            if (service == null) continue block2;
                            result.add(service);
                            continue block2;
                        }
                        continue;
                    }
                    return this.getServices(type, filter);
                }
            }
            catch (InvalidSyntaxException e) {
                LOGGER.error(String.format("Unable to retrieve the services of type %s.", type.getName()), (Throwable)e);
            }
        }
        if (!result.isEmpty()) {
            Object[] srv = (Object[])Array.newInstance(type, result.size());
            return result.toArray(srv);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        String[] objectClasses = (String[])serviceReference.getProperty("objectClass");
        if (objectClasses != null) {
            for (String key : objectClasses) {
                ServiceCache serviceCache = this;
                synchronized (serviceCache) {
                    SortedSet<Reference> references = this.cache.remove(key);
                    if (references != null) {
                        for (Reference reference : references) {
                            this.bundleContext.ungetService(reference.getServiceReference());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ServiceType> SortedSet<Reference> getCachedReferences(Class<ServiceType> type) {
        SortedSet<Reference> references;
        block9: {
            String key = type.getName();
            references = this.cache.get(key);
            if (references == null) {
                references = new ConcurrentSkipListSet(Comparator.reverseOrder());
                try {
                    Collection serviceReferences = this.bundleContext.getServiceReferences(type, null);
                    if (serviceReferences.isEmpty()) break block9;
                    ArrayList localReferences = new ArrayList(serviceReferences);
                    Collections.sort(localReferences);
                    Collections.reverse(localReferences);
                    for (ServiceReference ref : localReferences) {
                        references.add(new Reference(ref));
                    }
                    ServiceCache serviceCache = this;
                    synchronized (serviceCache) {
                        SortedSet<Reference> existing = this.cache.get(key);
                        if (existing != null) {
                            existing.addAll(references);
                            references = existing;
                        } else {
                            this.cache.put(key, references);
                        }
                    }
                }
                catch (InvalidSyntaxException e) {
                    LOGGER.error(String.format("Unable to retrieve the services of type %s.", type.getName()), (Throwable)e);
                }
            }
        }
        return references;
    }

    private final class Reference
    implements Comparable<Reference> {
        private final ServiceReference<?> serviceReference;
        private Object service;

        Reference(ServiceReference<?> serviceReference) {
            this.serviceReference = serviceReference;
        }

        @Override
        public int compareTo(@NotNull Reference o) {
            return this.serviceReference.compareTo(o.serviceReference);
        }

        synchronized Object getService() {
            if (this.service == null) {
                this.service = ServiceCache.this.bundleContext.getService(this.serviceReference);
            }
            return this.service;
        }

        ServiceReference<?> getServiceReference() {
            return this.serviceReference;
        }

        public int hashCode() {
            return Objects.hash(this.serviceReference);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Reference) {
                Reference other = (Reference)obj;
                return Objects.equals(this.serviceReference, other.serviceReference);
            }
            return false;
        }
    }
}

