/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.TCB;

@TCB
@NotThreadSafe
class ElementAndAttributePolicyBasedSanitizerPolicy
implements HtmlSanitizer.Policy {
    final ImmutableMap<String, ElementAndAttributePolicies> elAndAttrPolicies;
    final ImmutableSet<String> allowedTextContainers;
    private final HtmlStreamEventReceiver out;
    transient boolean skipText = true;
    private final List<String> openElementStack = Lists.newArrayList();
    static final ImmutableSet<String> SKIPPABLE_ELEMENT_CONTENT = ImmutableSet.of("script", "style", "noscript", "nostyle", "noembed", "noframes", new String[]{"iframe", "object", "frame", "frameset", "title"});

    ElementAndAttributePolicyBasedSanitizerPolicy(HtmlStreamEventReceiver out, ImmutableMap<String, ElementAndAttributePolicies> elAndAttrPolicies, ImmutableSet<String> allowedTextContainers) {
        this.out = out;
        this.elAndAttrPolicies = elAndAttrPolicies;
        this.allowedTextContainers = allowedTextContainers;
    }

    @Override
    public void openDocument() {
        this.skipText = false;
        this.openElementStack.clear();
        this.out.openDocument();
    }

    @Override
    public void closeDocument() {
        for (int i = this.openElementStack.size() - 1; i >= 0; i -= 2) {
            String tagNameToClose = this.openElementStack.get(i);
            if (tagNameToClose == null) continue;
            this.out.closeTag(tagNameToClose);
        }
        this.openElementStack.clear();
        this.skipText = true;
        this.out.closeDocument();
    }

    @Override
    public void text(String textChunk) {
        if (!this.skipText) {
            this.out.text(textChunk);
        }
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        ElementAndAttributePolicies policies = this.elAndAttrPolicies.get(elementName);
        String adjustedElementName = ElementAndAttributePolicyBasedSanitizerPolicy.applyPolicies(elementName, attrs, policies);
        if (!(adjustedElementName == null || attrs.isEmpty() && policies.htmlTagSkipType.skipAvailability())) {
            this.writeOpenTag(policies, adjustedElementName, attrs);
            return;
        }
        this.deferOpenTag(elementName);
    }

    @Nullable
    static final String applyPolicies(String elementName, List<String> attrs, ElementAndAttributePolicies policies) {
        String adjustedElementName;
        if (policies != null) {
            ListIterator<String> attrsIt = attrs.listIterator();
            while (attrsIt.hasNext()) {
                String name = attrsIt.next();
                AttributePolicy attrPolicy = policies.attrPolicies.get(name);
                if (attrPolicy == null) {
                    attrsIt.remove();
                    attrsIt.next();
                    attrsIt.remove();
                    continue;
                }
                String value = attrsIt.next();
                String adjustedValue = attrPolicy.apply(elementName, name, value);
                if (adjustedValue == null) {
                    attrsIt.remove();
                    attrsIt.previous();
                    attrsIt.remove();
                    continue;
                }
                attrsIt.set(adjustedValue);
            }
            ElementAndAttributePolicyBasedSanitizerPolicy.removeDuplicateAttributes(attrs);
            adjustedElementName = policies.elPolicy.apply(elementName, attrs);
            if (adjustedElementName != null) {
                adjustedElementName = HtmlLexer.canonicalElementName(adjustedElementName);
            }
        } else {
            adjustedElementName = null;
        }
        return adjustedElementName;
    }

    @Override
    public void closeTag(String elementName) {
        int n;
        int i = n = this.openElementStack.size();
        while (i > 0) {
            String openElementName = this.openElementStack.get(i -= 2);
            if (!elementName.equals(openElementName)) continue;
            for (int j = n - 1; j > i; j -= 2) {
                String tagNameToClose = this.openElementStack.get(j);
                if (tagNameToClose == null) continue;
                this.out.closeTag(tagNameToClose);
            }
            this.openElementStack.subList(i, n).clear();
            break;
        }
        this.skipText = false;
        for (i = this.openElementStack.size() - 1; i >= 0; i -= 2) {
            String adjustedName = this.openElementStack.get(i);
            if (adjustedName == null) continue;
            this.skipText = !this.allowedTextContainers.contains(adjustedName);
            break;
        }
    }

    void writeOpenTag(ElementAndAttributePolicies policies, String adjustedElementName, List<String> attrs) {
        if (!HtmlTextEscapingMode.isVoidElement(adjustedElementName)) {
            this.openElementStack.add(policies.elementName);
            this.openElementStack.add(adjustedElementName);
            this.skipText = !this.allowedTextContainers.contains(adjustedElementName);
        }
        this.out.openTag(adjustedElementName, attrs);
    }

    void deferOpenTag(String elementName) {
        if (!HtmlTextEscapingMode.isVoidElement(elementName)) {
            this.openElementStack.add(elementName);
            this.openElementStack.add(null);
        }
        this.skipText = SKIPPABLE_ELEMENT_CONTENT.contains(elementName);
    }

    private static void removeDuplicateAttributes(List<String> attrs) {
        int firstLetterMask = 0;
        int n = attrs.size();
        int k = 0;
        block0: for (int i = 0; i < n; i += 2) {
            int firstCharBit;
            String name = attrs.get(i);
            if (name.length() == 0) continue;
            int firstCharIndex = name.charAt(0) - 97;
            if (0 <= firstCharIndex && firstCharIndex <= 26 && (firstLetterMask & (firstCharBit = 1 << firstCharIndex)) == 0) {
                firstLetterMask |= firstCharBit;
            } else {
                int j = k;
                while (--j >= 0) {
                    if (!attrs.get(j).equals(name)) continue;
                    continue block0;
                }
            }
            if (k != i) {
                attrs.set(k, name);
                attrs.set(k + 1, attrs.get(i + 1));
            }
            k += 2;
        }
        if (k != n) {
            attrs.subList(k, n).clear();
        }
    }
}

