/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceURLStreamHandler;
import org.apache.sling.bundleresource.impl.PathMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleResource
extends AbstractResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResourceResolver resourceResolver;
    private final BundleResourceCache cache;
    private final PathMapping mappedPath;
    private final String path;
    private URL resourceUrl;
    private final ResourceMetadata metadata;
    private final ValueMap valueMap;
    private final Map<String, Map<String, Object>> subResources;

    public BundleResource(ResourceResolver resourceResolver, BundleResourceCache cache, PathMapping mappedPath, String resourcePath, Map<String, Object> readProps, boolean isFolder) {
        this.resourceResolver = resourceResolver;
        this.cache = cache;
        this.mappedPath = mappedPath;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(resourcePath);
        this.metadata.setCreationTime(this.cache.getBundle().getLastModified());
        this.metadata.setModificationTime(this.cache.getBundle().getLastModified());
        this.path = resourcePath;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.valueMap = new ValueMapDecorator(Collections.unmodifiableMap(properties));
        if (isFolder) {
            properties.put("sling:resourceType", "nt:folder");
        } else {
            properties.put("sling:resourceType", "nt:file");
            try {
                URL url = this.cache.getEntry(mappedPath.getEntryPath(resourcePath));
                if (url != null) {
                    this.metadata.setContentLength((long)url.openConnection().getContentLength());
                }
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        HashMap<String, Map> children = null;
        if (readProps != null) {
            for (Map.Entry<String, Object> entry : readProps.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    if (children == null) {
                        children = new HashMap<String, Map>();
                    }
                    children.put(entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.mappedPath.getJSONPropertiesExtension() != null) {
            String entryPath;
            String propsPath = mappedPath.getEntryPath(resourcePath.concat(this.mappedPath.getJSONPropertiesExtension()));
            if (propsPath == null && resourcePath.equals(mappedPath.getResourceRoot()) && (entryPath = mappedPath.getEntryPath(resourcePath)) != null) {
                propsPath = entryPath.concat(this.mappedPath.getJSONPropertiesExtension());
            }
            if (propsPath != null) {
                try {
                    URL url = this.cache.getEntry(propsPath);
                    if (url != null) {
                        JsonObject obj = Json.createReader((InputStream)url.openStream()).readObject();
                        for (Map.Entry entry : obj.entrySet()) {
                            Object value = BundleResource.getValue((JsonValue)entry.getValue(), true);
                            if (value == null) continue;
                            if (value instanceof Map) {
                                if (children == null) {
                                    children = new HashMap();
                                }
                                children.put((String)entry.getKey(), (Map)value);
                                continue;
                            }
                            properties.put((String)entry.getKey(), value);
                        }
                    }
                }
                catch (IOException ioe) {
                    this.log.error("getInputStream: Cannot get input stream for " + propsPath, (Throwable)ioe);
                }
            }
        }
        this.subResources = children;
    }

    Resource getChildResource(String path) {
        BundleResource result = null;
        Map<String, Map<String, Object>> resources = this.subResources;
        String subPath = null;
        for (String segment : path.split("/")) {
            Map<String, Object> props;
            if (resources != null) {
                subPath = subPath == null ? segment : subPath.concat("/").concat(segment);
                props = resources.get(segment);
                if (props == null) {
                    result = null;
                    break;
                }
            } else {
                result = null;
                break;
            }
            result = new BundleResource(this.resourceResolver, this.cache, this.mappedPath, this.getPath().concat("/").concat(subPath), props, false);
            resources = result.subResources;
        }
        return result;
    }

    private static Object getValue(JsonValue value, boolean topLevel) {
        switch (value.getValueType()) {
            case NULL: {
                return null;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    return num.longValue();
                }
                return num.doubleValue();
            }
            case ARRAY: {
                ArrayList<Object> array = new ArrayList<Object>();
                for (JsonValue x : (JsonArray)value) {
                    array.add(BundleResource.getValue(x, false));
                }
                return array;
            }
            case OBJECT: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                JsonObject obj = (JsonObject)value;
                for (Map.Entry entry : obj.entrySet()) {
                    map.put((String)entry.getKey(), BundleResource.getValue((JsonValue)entry.getValue(), false));
                }
                return map;
            }
        }
        return null;
    }

    Map<String, Map<String, Object>> getSubResources() {
        return this.subResources;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return (String)this.valueMap.get("sling:resourceType", String.class);
    }

    public String getResourceSuperType() {
        return (String)this.valueMap.get("sling:resourceSuperType", String.class);
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == URL.class) {
            return (Type)this.getURL();
        }
        if (type == ValueMap.class) {
            return (Type)this.valueMap;
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", path=" + this.getPath();
    }

    private InputStream getInputStream() {
        if (this.isFile()) {
            try {
                URL url = this.getURL();
                if (url != null) {
                    return url.openStream();
                }
            }
            catch (IOException ioe) {
                this.log.error("getInputStream: Cannot get input stream for " + (Object)((Object)this), (Throwable)ioe);
            }
        }
        return null;
    }

    private URL getURL() {
        URL url;
        if (this.resourceUrl == null && (url = this.cache.getEntry(this.mappedPath.getEntryPath(this.path))) != null) {
            try {
                this.resourceUrl = new URL("bundle", null, -1, this.path, new BundleResourceURLStreamHandler(this.cache.getBundle(), this.mappedPath.getEntryPath(this.path)));
            }
            catch (MalformedURLException mue) {
                this.log.error("getURL: Cannot get URL for " + (Object)((Object)this), (Throwable)mue);
            }
        }
        return this.resourceUrl;
    }

    BundleResourceCache getBundle() {
        return this.cache;
    }

    PathMapping getMappedPath() {
        return this.mappedPath;
    }

    boolean isFile() {
        return "nt:file".equals(this.getResourceType());
    }
}

