/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource.type;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

public final class ResourceType {
    private static final Pattern versionPattern = Pattern.compile("(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?$");
    private final String type;
    private final Version version;
    private final String resourceLabel;
    private final String toString;

    private ResourceType(@NotNull String type, @Nullable Version version) {
        this.type = type;
        this.version = version;
        this.resourceLabel = type.lastIndexOf(47) != -1 ? type.substring(type.lastIndexOf(47) + 1) : (type.lastIndexOf(46) != -1 ? type.substring(type.lastIndexOf(46) + 1) : type);
        this.toString = type + (version == null ? "" : "/" + version);
    }

    @NotNull
    public String getResourceLabel() {
        return this.resourceLabel;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toString;
    }

    @NotNull
    public static ResourceType parseResourceType(@NotNull String resourceTypeString) {
        String type = "";
        Version version = null;
        if (StringUtils.isNotEmpty((CharSequence)resourceTypeString)) {
            int lastSlash = resourceTypeString.lastIndexOf(47);
            if (lastSlash != -1 && !resourceTypeString.endsWith("/")) {
                String versionString = resourceTypeString.substring(lastSlash + 1);
                if (versionPattern.matcher(versionString).matches()) {
                    try {
                        version = Version.parseVersion((String)versionString);
                        type = resourceTypeString.substring(0, lastSlash);
                    }
                    catch (IllegalArgumentException e) {
                        type = resourceTypeString;
                    }
                } else {
                    type = resourceTypeString;
                }
            } else {
                type = resourceTypeString;
            }
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new IllegalArgumentException(String.format("Cannot extract a type for the resourceTypeString %s.", resourceTypeString));
        }
        return new ResourceType(type, version);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.version, this.resourceLabel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourceType) {
            ResourceType other = (ResourceType)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.resourceLabel, other.resourceLabel);
        }
        return false;
    }
}

