/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ProtectionConfig;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ProtectionConfig.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class ProtectionConfigImpl
implements ProtectionConfig {
    private Set<String> propertyNames = Collections.emptySet();
    private Set<String> nodeNames = Collections.emptySet();

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.propertyNames = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray((Object)properties.get("propertyNames"), (String[])new String[0]));
        this.nodeNames = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray((Object)properties.get("nodeNames"), (String[])new String[0]));
    }

    @Override
    public boolean isProtectedProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return !this.propertyNames.contains(property.getName());
    }

    @Override
    public boolean isProtectedTree(@NotNull Tree tree) {
        return !this.nodeNames.contains(tree.getName());
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak External Identity Protection Exclusion List", description="Implementation of ProtectionConfig that marks all properties and trees as protected except for those specified matching the names in the 2 allow lists.")
    static @interface Configuration {
        @AttributeDefinition(name="Property Allow List", description="Names of properties that are excluded from the protection status.", cardinality=0x7FFFFFFF)
        public String[] propertyNames() default {};

        @AttributeDefinition(name="Node Allow List", description="Names of nodes that are excluded from the protection status. Note that the exception is applied to the whole subtree.", cardinality=0x7FFFFFFF)
        public String[] nodeNames() default {};
    }
}

