/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ProtectionConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.monitor.ExternalIdentityMonitor;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.monitor.ExternalIdentityMonitorImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.AutomembershipService;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.DynamicGroupMembershipService;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.DynamicGroupValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalGroupPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityConflictHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityImporter;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityRepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalUserValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.IdentityProtectionType;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ProtectionConfigTracker;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncConfigTracker;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncHandlerMappingTracker;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SystemPrincipalConfig;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipService;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.stats.Monitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, label="Apache Jackrabbit Oak External PrincipalConfiguration", immediate=true)
@Service(value={PrincipalConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="protectExternalId", label="External Identity Protection", description="If disabled rep:externalId properties won't be properly protected (backwards compatible behavior). NOTE: for security reasons it is strongly recommend to keep the protection enabled!", boolValue={true}), @Property(name="protectExternalIdentities", label="External User and Group Protection", description="If 'None' is selected the synchronized external users/groups won't be protected (backwards compatible behavior) and can be edited like local users/groups. NOTE: in order to avoid having inconsistencies between the IDP that defines the external identities and local synced identities it is recommend to enable the protection. With option 'Warn' the protection is disabled but warnings will be logged.", options={@PropertyOption(name="None", value="None"), @PropertyOption(name="Warn", value="Warn"), @PropertyOption(name="Protected", value="Protected")}), @Property(name="systemPrincipalNames", label="System Principal Names", description="Names of additional 'SystemUserPrincipal' instances that are excluded from the protection check. Note that this configuration does not grant the required permission to perform the operation.", value={}, cardinality=10), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalPrincipalConfiguration"})})
public class ExternalPrincipalConfiguration
extends ConfigurationBase
implements PrincipalConfiguration {
    private SyncConfigTracker syncConfigTracker;
    private SyncHandlerMappingTracker syncHandlerMappingTracker;
    private ProtectionConfigTracker protectionConfigTracker;
    private ServiceRegistration automembershipRegistration;
    private ServiceRegistration dynamicMembershipRegistration;
    private ExternalIdentityMonitor monitor = ExternalIdentityMonitor.NOOP;

    public ExternalPrincipalConfiguration() {
    }

    public ExternalPrincipalConfiguration(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.principal"));
    }

    @NotNull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @NotNull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        if (this.dynamicMembershipEnabled()) {
            UserConfiguration uc = (UserConfiguration)this.getSecurityProvider().getConfiguration(UserConfiguration.class);
            return new ExternalGroupPrincipalProvider(root, uc.getUserManager(root, namePathMapper), namePathMapper, this.syncConfigTracker);
        }
        return EmptyPrincipalProvider.INSTANCE;
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return new ExternalIdentityRepositoryInitializer(this.protectedExternalIds());
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        IdentityProtectionType ipt;
        boolean isSystem = new SystemPrincipalConfig(this.getPrincipalNames()).containsSystemPrincipal(principals);
        ImmutableList.Builder vps = new ImmutableList.Builder();
        vps.add((Object)new ExternalIdentityValidatorProvider(isSystem, this.protectedExternalIds()));
        Set<String> idpNamesWithDynamicGroups = this.getIdpNamesWithDynamicGroups();
        if (!idpNamesWithDynamicGroups.isEmpty()) {
            vps.add((Object)new DynamicGroupValidatorProvider(this.getRootProvider(), this.getTreeProvider(), this.getSecurityProvider(), idpNamesWithDynamicGroups));
        }
        if ((ipt = this.getIdentityProtectionType()) != IdentityProtectionType.NONE && !isSystem) {
            vps.add((Object)new ExternalUserValidatorProvider(this.getRootProvider(), this.getTreeProvider(), this.getSecurityProvider(), ipt, this.getProtectionConfig()));
        }
        return vps.build();
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new ExternalIdentityImporter(new SystemPrincipalConfig(this.getPrincipalNames())));
    }

    @NotNull
    public Iterable<Monitor<?>> getMonitors(@NotNull StatisticsProvider statisticsProvider) {
        this.monitor = new ExternalIdentityMonitorImpl(statisticsProvider);
        return Collections.singleton(this.monitor);
    }

    @NotNull
    public List<ThreeWayConflictHandler> getConflictHandlers() {
        return Collections.singletonList(new ExternalIdentityConflictHandler());
    }

    @Activate
    private void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
        this.syncHandlerMappingTracker = new SyncHandlerMappingTracker(bundleContext);
        this.syncHandlerMappingTracker.open();
        this.syncConfigTracker = new SyncConfigTracker(bundleContext, this.syncHandlerMappingTracker);
        this.syncConfigTracker.open();
        this.protectionConfigTracker = new ProtectionConfigTracker(bundleContext);
        this.protectionConfigTracker.open();
        this.automembershipRegistration = bundleContext.registerService(DynamicMembershipService.class.getName(), (Object)new AutomembershipService(this.syncConfigTracker), null);
        this.dynamicMembershipRegistration = bundleContext.registerService(DynamicMembershipService.class.getName(), (Object)new DynamicGroupMembershipService(this.syncConfigTracker), null);
    }

    @Deactivate
    private void deactivate() {
        if (this.syncConfigTracker != null) {
            this.syncConfigTracker.close();
        }
        if (this.syncHandlerMappingTracker != null) {
            this.syncHandlerMappingTracker.close();
        }
        if (this.protectionConfigTracker != null) {
            this.protectionConfigTracker.close();
        }
        if (this.automembershipRegistration != null) {
            this.automembershipRegistration.unregister();
        }
        if (this.dynamicMembershipRegistration != null) {
            this.dynamicMembershipRegistration.unregister();
        }
    }

    private boolean dynamicMembershipEnabled() {
        return this.syncConfigTracker != null && this.syncConfigTracker.isEnabled();
    }

    @NotNull
    private Set<String> getIdpNamesWithDynamicGroups() {
        return this.syncConfigTracker == null ? Collections.emptySet() : this.syncConfigTracker.getIdpNamesWithDynamicGroups();
    }

    private boolean protectedExternalIds() {
        return (Boolean)this.getParameters().getConfigValue("protectExternalId", (Object)true);
    }

    @NotNull
    private IdentityProtectionType getIdentityProtectionType() {
        return IdentityProtectionType.fromLabel((String)this.getParameters().getConfigValue("protectExternalIdentities", (Object)"None"));
    }

    @NotNull
    private ProtectionConfig getProtectionConfig() {
        return this.protectionConfigTracker == null ? ProtectionConfig.DEFAULT : this.protectionConfigTracker;
    }

    @NotNull
    private Set<String> getPrincipalNames() {
        return (Set)this.getParameters().getConfigValue("systemPrincipalNames", Collections.emptySet());
    }
}

