/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Calendar;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;

class ExternalIdentityConflictHandler
implements ThreeWayConflictHandler {
    ExternalIdentityConflictHandler() {
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        if ("rep:lastSynced".equals(ours.getName())) {
            return ExternalIdentityConflictHandler.merge(parent, ours, theirs);
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        if ("rep:lastSynced".equals(ours.getName())) {
            return ExternalIdentityConflictHandler.merge(parent, ours, theirs);
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static ThreeWayConflictHandler.Resolution merge(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        Calendar o = ISO8601.parse((String)((String)ours.getValue(Type.DATE)));
        Calendar t = ISO8601.parse((String)((String)theirs.getValue(Type.DATE)));
        if (o != null) {
            Calendar v = o.before(t) ? t : o;
            parent.setProperty(ours.getName(), (Object)v);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        if (t != null) {
            parent.setProperty(ours.getName(), (Object)t);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState theirs) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState theirs, @NotNull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState base) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }
}

