/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.AutoMembershipPrincipals;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.DynamicGroupUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.InheritedMembershipIterator;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncConfigTracker;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalGroupPrincipalProvider
implements PrincipalProvider,
ExternalIdentityConstants,
DynamicMembershipProvider {
    private static final Logger log = LoggerFactory.getLogger(ExternalGroupPrincipalProvider.class);
    private static final String BINDING_PRINCIPAL_NAMES = "principalNames";
    private final Root root;
    private final NamePathMapper namePathMapper;
    private final UserManager userManager;
    private final Set<String> idpNamesWithDynamicGroups;
    private final boolean hasOnlyDynamicGroups;
    private final AutoMembershipPrincipals autoMembershipPrincipals;
    private final AutoMembershipPrincipals groupAutoMembershipPrincipals;

    ExternalGroupPrincipalProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper, @NotNull SyncConfigTracker syncConfigTracker) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.userManager = userManager;
        this.idpNamesWithDynamicGroups = syncConfigTracker.getIdpNamesWithDynamicGroups();
        this.hasOnlyDynamicGroups = this.idpNamesWithDynamicGroups.size() == syncConfigTracker.getServiceReferences().length;
        this.autoMembershipPrincipals = new AutoMembershipPrincipals(userManager, syncConfigTracker.getAutoMembership(), syncConfigTracker.getAutoMembershipConfig());
        this.groupAutoMembershipPrincipals = this.idpNamesWithDynamicGroups.isEmpty() ? null : new AutoMembershipPrincipals(userManager, syncConfigTracker.getGroupAutoMembership(), syncConfigTracker.getAutoMembershipConfig());
    }

    ExternalGroupPrincipalProvider(@NotNull Root root, @NotNull UserConfiguration userConfiguration, @NotNull NamePathMapper namePathMapper, @NotNull String idpName, @NotNull DefaultSyncConfig syncConfig, @NotNull Set<String> idpNamesWithDynamicGroups, boolean hasOnlyDynamicGroups) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.userManager = userConfiguration.getUserManager(root, namePathMapper);
        this.idpNamesWithDynamicGroups = idpNamesWithDynamicGroups;
        this.hasOnlyDynamicGroups = hasOnlyDynamicGroups;
        this.autoMembershipPrincipals = new AutoMembershipPrincipals(this.userManager, Collections.singletonMap(idpName, (String[])Iterables.toArray((Iterable)Iterables.concat(syncConfig.user().getAutoMembership(), syncConfig.group().getAutoMembership()), String.class)), Collections.singletonMap(idpName, syncConfig.user().getAutoMembershipConfig()));
        this.groupAutoMembershipPrincipals = idpNamesWithDynamicGroups.isEmpty() ? null : new AutoMembershipPrincipals(this.userManager, Collections.singletonMap(idpName, syncConfig.group().getAutoMembership().toArray(new String[0])), Collections.singletonMap(idpName, syncConfig.group().getAutoMembershipConfig()));
    }

    public Principal getPrincipal(@NotNull String principalName) {
        Iterator rows;
        if (this.hasOnlyDynamicGroups) {
            return null;
        }
        Result result = this.findPrincipals(principalName, true);
        Iterator iterator = rows = result == null ? Collections.emptyIterator() : result.getRows().iterator();
        if (rows.hasNext()) {
            return this.createExternalGroupPrincipal(principalName, DynamicGroupUtil.getIdpName((ResultRow)rows.next()));
        }
        return null;
    }

    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        block5: {
            if (this.hasDynamicMembershipPrincipals(principal)) {
                try {
                    if (principal instanceof ItemBasedPrincipal) {
                        String path = ((ItemBasedPrincipal)principal).getPath();
                        Tree t = this.root.getTree(path);
                        Authorizable a = this.userManager.getAuthorizableByPath(path);
                        if (a != null) {
                            return this.getGroupPrincipals(a, t);
                        }
                        break block5;
                    }
                    return this.getGroupPrincipals(this.userManager.getAuthorizable(principal), false);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
        }
        return ImmutableSet.of();
    }

    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String userID) {
        try {
            return this.getGroupPrincipals(this.userManager.getAuthorizable(userID), true);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return ImmutableSet.of();
        }
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        if (1 == searchType || this.hasOnlyDynamicGroups) {
            return Collections.emptyIterator();
        }
        Result result = this.findPrincipals(Strings.nullToEmpty((String)nameHint), false);
        if (result != null) {
            return Iterators.filter((Iterator)((Object)new GroupPrincipalIterator(nameHint, result)), Objects::nonNull);
        }
        return Collections.emptyIterator();
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        Iterator<? extends Principal> principals = this.findPrincipals(nameHint, searchType);
        if (!principals.hasNext()) {
            return Collections.emptyIterator();
        }
        Spliterator<? extends Principal> spliterator = Spliterators.spliteratorUnknownSize(principals, 0);
        Stream<? extends Principal> stream = StreamSupport.stream(spliterator, false);
        stream = stream.sorted(Comparator.comparing(Principal::getName));
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (limit >= 0L) {
            stream = stream.limit(limit);
        }
        return stream.iterator();
    }

    public boolean coversAllMembers(@NotNull Group group) {
        return this.isDynamic((Authorizable)group) && !DynamicGroupUtil.hasStoredMemberInfo(group, this.root);
    }

    @NotNull
    public Iterator<Authorizable> getMembers(@NotNull Group group, boolean includeInherited) throws RepositoryException {
        if (!this.isDynamic((Authorizable)group)) {
            return Collections.emptyIterator();
        }
        Result result = this.findPrincipals(group.getPrincipal().getName(), true);
        if (result != null) {
            return new MemberIterator<Authorizable>(result){

                @Override
                Authorizable get(@NotNull Authorizable authorizable) {
                    return authorizable;
                }
            };
        }
        return Collections.emptyIterator();
    }

    public boolean isMember(@NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (authorizable.isGroup() || !this.isDynamic(authorizable)) {
            return false;
        }
        if (this.isDynamic((Authorizable)group) && ExternalGroupPrincipalProvider.isDynamicMember(group.getPrincipal().getName(), authorizable)) {
            return true;
        }
        if (includeInherited) {
            Iterator<Group> dynamicGroups = this.getMembership(authorizable, false);
            while (dynamicGroups.hasNext()) {
                Group dynamicGroup = dynamicGroups.next();
                if (!group.isMember((Authorizable)dynamicGroup)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Iterator<Group> getMembership(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        if (authorizable.isGroup() || !this.isDynamic(authorizable)) {
            return Collections.emptyIterator();
        }
        Object[] vs = authorizable.getProperty("rep:externalPrincipalNames");
        if (vs == null || vs.length == 0) {
            return Collections.emptyIterator();
        }
        ImmutableSet valueSet = ImmutableSet.copyOf((Object[])vs);
        UnmodifiableIterator declared = Iterators.filter((Iterator)Iterators.transform(valueSet.iterator(), value -> {
            try {
                String groupPrincipalName = value.getString();
                Authorizable gr = this.userManager.getAuthorizable((Principal)new PrincipalImpl(groupPrincipalName));
                return ExternalGroupPrincipalProvider.isValidGroup(gr, authorizable) ? (Group)gr : null;
            }
            catch (RepositoryException e) {
                return null;
            }
        }), Objects::nonNull);
        if (includeInherited) {
            return new InheritedMembershipIterator((Iterator<Group>)declared);
        }
        return declared;
    }

    private static boolean isValidGroup(@Nullable Authorizable group, @NotNull Authorizable member) throws RepositoryException {
        if (group == null || !group.isGroup()) {
            return false;
        }
        return DynamicGroupUtil.isSameIDP(group, member);
    }

    private boolean isDynamic(@NotNull Authorizable authorizable) {
        if (this.idpNamesWithDynamicGroups.isEmpty()) {
            return false;
        }
        try {
            ExternalIdentityRef extIdRef = DefaultSyncContext.getIdentityRef(authorizable);
            if (extIdRef == null) {
                return false;
            }
            return this.idpNamesWithDynamicGroups.contains(extIdRef.getProviderName());
        }
        catch (RepositoryException e) {
            log.warn("Cannot retrieve rep:externalId property from identity {}", (Object)authorizable);
            return false;
        }
    }

    @NotNull
    private Set<Principal> getGroupPrincipals(@Nullable Authorizable authorizable, boolean ignoreGroup) throws RepositoryException {
        if (authorizable == null || authorizable.isGroup() && ignoreGroup) {
            return ImmutableSet.of();
        }
        return this.getGroupPrincipals(authorizable, DynamicGroupUtil.getTree(authorizable, this.root));
    }

    @NotNull
    private Set<Principal> getGroupPrincipals(@NotNull Authorizable authorizable, @NotNull Tree tree) throws RepositoryException {
        if (!tree.exists()) {
            return Collections.emptySet();
        }
        String idpName = DynamicGroupUtil.getIdpName(tree);
        if (idpName == null) {
            return Collections.emptySet();
        }
        if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER)) {
            PropertyState ps = tree.getProperty("rep:externalPrincipalNames");
            if (ps != null) {
                HashSet groupPrincipals = Sets.newHashSet();
                for (String principalName : (Iterable)ps.getValue(Type.STRINGS)) {
                    groupPrincipals.add(this.createExternalGroupPrincipal(principalName, idpName));
                }
                groupPrincipals.addAll(this.getInheritedPrincipals(groupPrincipals, idpName));
                groupPrincipals.addAll(this.getAutomembershipPrincipals(idpName, authorizable));
                return groupPrincipals;
            }
            return Collections.emptySet();
        }
        return this.getAutomembershipPrincipals(idpName, authorizable);
    }

    private Set<Principal> getInheritedPrincipals(@NotNull Set<Principal> externalGroupPrincipals, @NotNull String idpName) {
        if (this.idpNamesWithDynamicGroups.contains(idpName)) {
            HashSet<Principal> inherited = new HashSet<Principal>();
            for (Principal p : externalGroupPrincipals) {
                inherited.addAll(DynamicGroupUtil.getInheritedPrincipals(p, this.userManager));
            }
            return inherited;
        }
        return Collections.emptySet();
    }

    private Set<Principal> getAutomembershipPrincipals(@NotNull String idpName, @NotNull Authorizable authorizable) {
        if (authorizable.isGroup()) {
            return this.idpNamesWithDynamicGroups.contains(idpName) ? this.groupAutoMembershipPrincipals.getAutoMembership(idpName, authorizable, true).keySet() : Collections.emptySet();
        }
        return this.autoMembershipPrincipals.getAutoMembership(idpName, authorizable, true).keySet();
    }

    @Nullable
    private Result findPrincipals(@NotNull String nameHint, boolean exactMatch) {
        try {
            Map<String, ? extends PropertyValue> bindings = ExternalGroupPrincipalProvider.buildBinding(nameHint, exactMatch);
            String op = exactMatch ? " = " : " LIKE ";
            String statement = "SELECT [rep:externalPrincipalNames] FROM [rep:User] WHERE PROPERTY([rep:externalPrincipalNames], 'String')" + op + "$principalNames /* oak-internal */";
            return this.root.getQueryEngine().executeQuery(statement, "JCR-SQL2", bindings, this.namePathMapper.getSessionLocalMappings());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @NotNull
    private static Map<String, ? extends PropertyValue> buildBinding(@NotNull String nameHint, boolean exactMatch) {
        Object val = nameHint;
        if (!exactMatch) {
            val = nameHint.isEmpty() ? "%" : "%" + nameHint.replace("%", "\\%").replace("_", "\\_") + "%";
        }
        return Collections.singletonMap(BINDING_PRINCIPAL_NAMES, PropertyValues.newString((String)val));
    }

    private static boolean isDynamicMember(@NotNull String groupPrincipalName, @Nullable Authorizable member) throws RepositoryException {
        if (member == null || member.isGroup()) {
            return false;
        }
        Value[] vs = member.getProperty("rep:externalPrincipalNames");
        if (vs == null) {
            return false;
        }
        for (Value v : vs) {
            if (!groupPrincipalName.equals(v.getString())) continue;
            return true;
        }
        return false;
    }

    private boolean hasDynamicMembershipPrincipals(@NotNull Principal principal) {
        if (!GroupPrincipals.isGroup((Principal)principal)) {
            return true;
        }
        if (principal instanceof ExternalGroupPrincipal) {
            return this.idpNamesWithDynamicGroups.contains(((ExternalGroupPrincipal)((Object)principal)).getIdpName());
        }
        return principal instanceof ItemBasedPrincipal;
    }

    private GroupPrincipal createExternalGroupPrincipal(@NotNull String principalName, @Nullable String idpName) {
        if (this.idpNamesWithDynamicGroups.contains(idpName)) {
            return new ExternalGroupPrincipalItemBased(principalName, idpName);
        }
        return new ExternalGroupPrincipal(principalName, idpName);
    }

    private abstract class MemberIterator<T>
    extends AbstractLazyIterator<T> {
        private final Iterator<? extends ResultRow> rows;

        private MemberIterator(Result queryResult) {
            this.rows = queryResult.getRows().iterator();
        }

        @Nullable
        protected T getNext() {
            while (this.rows.hasNext()) {
                String userPath = this.rows.next().getPath();
                try {
                    Authorizable authorizable = ExternalGroupPrincipalProvider.this.userManager.getAuthorizableByPath(userPath);
                    if (authorizable == null) continue;
                    return this.get(authorizable);
                }
                catch (RepositoryException e) {
                    log.debug("{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        abstract T get(@NotNull Authorizable var1) throws RepositoryException;
    }

    private final class GroupPrincipalIterator
    extends AbstractLazyIterator<Principal> {
        private final Set<String> processed = new HashSet<String>();
        private final String queryString;
        private final Iterator<? extends ResultRow> rows;
        private Iterator<String> propValues = Collections.emptyIterator();
        private String idpName = "";

        private GroupPrincipalIterator(@NotNull String queryString, Result queryResult) {
            this.queryString = queryString;
            this.rows = queryResult.getRows().iterator();
        }

        @Nullable
        protected Principal getNext() {
            if (!this.propValues.hasNext()) {
                if (this.rows.hasNext()) {
                    ResultRow row = this.rows.next();
                    this.propValues = Iterators.filter(((Iterable)row.getValue("rep:externalPrincipalNames").getValue(Type.STRINGS)).iterator(), Objects::nonNull);
                    this.idpName = DynamicGroupUtil.getIdpName(row);
                } else {
                    this.propValues = Collections.emptyIterator();
                }
            }
            while (this.propValues.hasNext()) {
                String principalName = this.propValues.next();
                if (this.processed.contains(principalName) || !this.matchesQuery(principalName)) continue;
                this.processed.add(principalName);
                return ExternalGroupPrincipalProvider.this.createExternalGroupPrincipal(principalName, this.idpName);
            }
            return null;
        }

        private boolean matchesQuery(@NotNull String principalName) {
            if (this.queryString == null) {
                return true;
            }
            return principalName.contains(this.queryString);
        }
    }

    private class ExternalGroupPrincipal
    extends PrincipalImpl
    implements GroupPrincipal {
        private final String idpName;

        private ExternalGroupPrincipal(@Nullable String principalName, String idpName) {
            super(principalName);
            this.idpName = Strings.nullToEmpty((String)idpName);
        }

        @NotNull
        private String getIdpName() {
            return this.idpName;
        }

        public boolean isMember(@NotNull Principal member) {
            if (GroupPrincipals.isGroup((Principal)member)) {
                return false;
            }
            try {
                return this.isContainedInExternalPrincipalNames(member);
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
                return false;
            }
        }

        private boolean isContainedInExternalPrincipalNames(@NotNull Principal member) throws RepositoryException {
            String name = this.getName();
            if (member instanceof ItemBasedPrincipal) {
                Tree tree = ExternalGroupPrincipalProvider.this.root.getTree(((ItemBasedPrincipal)member).getPath());
                if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER)) {
                    PropertyState ps = tree.getProperty("rep:externalPrincipalNames");
                    return ps != null && Iterables.contains((Iterable)((Iterable)ps.getValue(Type.STRINGS)), (Object)name);
                }
            } else {
                Authorizable a = ExternalGroupPrincipalProvider.this.userManager.getAuthorizable(member);
                return ExternalGroupPrincipalProvider.isDynamicMember(name, a);
            }
            return false;
        }

        @NotNull
        public Enumeration<? extends Principal> members() {
            Result result = ExternalGroupPrincipalProvider.this.findPrincipals(this.getName(), true);
            if (result != null) {
                return Iterators.asEnumeration((Iterator)((Object)new MemberIterator<Principal>(result){

                    @Override
                    Principal get(@NotNull Authorizable authorizable) throws RepositoryException {
                        return authorizable.getPrincipal();
                    }
                }));
            }
            return Iterators.asEnumeration(Collections.emptyIterator());
        }
    }

    private final class ExternalGroupPrincipalItemBased
    extends ExternalGroupPrincipal
    implements ItemBasedPrincipal {
        private ExternalGroupPrincipalItemBased(@Nullable String principalName, String idpName) {
            super(principalName, idpName);
        }

        @NotNull
        public String getPath() throws RepositoryException {
            Authorizable a = ExternalGroupPrincipalProvider.this.userManager.getAuthorizable((Principal)((Object)this));
            if (a == null) {
                throw new RepositoryException("Cannot determine path for principal '" + this.getName() + "'. Group with this principal name does not exist.");
            }
            return a.getPath();
        }
    }
}

