/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncHandlerMappingTracker;
import org.apache.jackrabbit.oak.spi.security.user.action.AbstractGroupAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthorizableActionProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"oak.security.name=org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalAuthorizableActionProvider"})
@Designate(ocd=Configuration.class)
public final class ExternalAuthorizableActionProvider
implements AuthorizableActionProvider {
    private static final Logger log = LoggerFactory.getLogger(ExternalAuthorizableActionProvider.class);
    private boolean failAddMembersForDifferentIdp = false;
    private SyncHandlerMappingTracker syncHandlerMappingTracker;
    private AutomembershipTracker automembershipTracker;

    @Activate
    public void activate(@NotNull BundleContext bundleContext, @NotNull Configuration configuration) {
        this.failAddMembersForDifferentIdp = configuration.failAddMembersForDifferentIdp();
        this.syncHandlerMappingTracker = new SyncHandlerMappingTracker(bundleContext);
        this.syncHandlerMappingTracker.open();
        this.automembershipTracker = new AutomembershipTracker(bundleContext, this.syncHandlerMappingTracker);
        this.automembershipTracker.open();
    }

    @Deactivate
    public void deactivate() {
        if (this.automembershipTracker != null) {
            this.automembershipTracker.close();
        }
        if (this.syncHandlerMappingTracker != null) {
            this.syncHandlerMappingTracker.close();
        }
    }

    @NotNull
    public List<? extends AuthorizableAction> getAuthorizableActions(@NotNull SecurityProvider securityProvider) {
        return Collections.singletonList(new IdpBoundaryAction());
    }

    @Nullable
    private static String getIdpName(@Nullable ExternalIdentityRef ref) {
        return ref == null ? null : ref.getProviderName();
    }

    private static final class AutomembershipTracker
    extends ServiceTracker {
        private final SyncHandlerMappingTracker mappingTracker;
        private final Set<ServiceReference> refs = new HashSet<ServiceReference>();
        private final Map<String, Set<String>> userAutoMembership = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> groupAutoMembership = new HashMap<String, Set<String>>();

        AutomembershipTracker(@NotNull BundleContext context, @NotNull SyncHandlerMappingTracker mappingTracker) {
            super(context, SyncHandler.class.getName(), null);
            this.mappingTracker = mappingTracker;
        }

        public Object addingService(ServiceReference reference) {
            this.refs.add(reference);
            this.userAutoMembership.clear();
            this.groupAutoMembership.clear();
            return super.addingService(reference);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.refs.add(reference);
            this.userAutoMembership.clear();
            this.groupAutoMembership.clear();
            super.modifiedService(reference, service);
        }

        public void removedService(ServiceReference reference, Object service) {
            this.refs.remove(reference);
            this.userAutoMembership.clear();
            this.groupAutoMembership.clear();
            super.removedService(reference, service);
        }

        @NotNull
        private Map<String, Set<String>> getAutomembership(boolean memberIsGroup) {
            Map<String, Set<String>> autoMembership;
            Map<String, Set<String>> map = autoMembership = memberIsGroup ? this.groupAutoMembership : this.userAutoMembership;
            if (autoMembership.isEmpty() && !this.refs.isEmpty()) {
                for (ServiceReference ref : this.refs) {
                    String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
                    String[] userMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("user.autoMembership"), (String[])new String[0]);
                    String[] groupMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("group.autoMembership"), (String[])new String[0]);
                    for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
                        AutomembershipTracker.updateAutoMembershipMap(this.userAutoMembership, syncHandlerName, idpName, userMembership);
                        AutomembershipTracker.updateAutoMembershipMap(this.groupAutoMembership, syncHandlerName, idpName, groupMembership);
                    }
                }
            }
            return autoMembership;
        }

        private static void updateAutoMembershipMap(@NotNull Map<String, Set<String>> map, @NotNull String syncHandlerName, @NotNull String idpName, @NotNull String[] membership) {
            ImmutableSet userMembership = ImmutableSet.copyOf((Object[])membership);
            Set<String> previous = map.put(idpName, (Set<String>)userMembership);
            if (previous != null) {
                String msg = previous.equals(userMembership) ? "Duplicate" : "Colliding";
                log.debug("{} auto-membership configuration for IDP '{}'; replacing previous values {} by {} defined by SyncHandler '{}'", new Object[]{msg, idpName, previous, userMembership, syncHandlerName});
            }
        }

        private boolean isAutoMembership(@NotNull String idpName, @NotNull String groupId, boolean memberIsGroup) {
            Set<String> ids = this.getAutomembership(memberIsGroup).get(idpName);
            return ids != null && ids.contains(groupId);
        }
    }

    private final class IdpBoundaryAction
    extends AbstractGroupAction {
        private IdpBoundaryAction() {
        }

        public void onMemberAdded(@NotNull Group group, @NotNull Authorizable member, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
            ExternalIdentityRef memberRef = DefaultSyncContext.getIdentityRef(member);
            String idpName = ExternalAuthorizableActionProvider.getIdpName(memberRef);
            if (idpName == null) {
                return;
            }
            String groupIdpName = ExternalAuthorizableActionProvider.getIdpName(DefaultSyncContext.getIdentityRef((Authorizable)group));
            if (idpName.equals(groupIdpName)) {
                return;
            }
            String groupId = group.getID();
            if (ExternalAuthorizableActionProvider.this.automembershipTracker != null && ExternalAuthorizableActionProvider.this.automembershipTracker.isAutoMembership(idpName, groupId, member.isGroup())) {
                return;
            }
            String extId = memberRef.getString();
            String msg = String.format("Attempt to add external identity '%s' as member of group '%s' defined by IDP '%s'.", extId, groupId, groupIdpName);
            log.warn(msg);
            if (ExternalAuthorizableActionProvider.this.failAddMembersForDifferentIdp) {
                throw new ConstraintViolationException(msg);
            }
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak ExternalAuthorizableActionProvider", description="Implementation of the AuthorizableActionProvider that specifically covers operations for users/groups defined by an external IDP that get synced into the repository.")
    static @interface Configuration {
        @AttributeDefinition(name="Behavior when Adding Members from Different IDP", description="Defines if Group.addMember should fail when adding a member defined by a different IDP. If set to false only a warning is logged.")
        public boolean failAddMembersForDifferentIdp() default false;
    }
}

