/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.SubtreeValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.DynamicGroupUtil;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class DynamicGroupValidatorProvider
extends ValidatorProvider
implements ExternalIdentityConstants {
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private final Set<String> idpNamesWithDynamicGroups;
    private final String groupRootPath;
    private Root rootBefore;
    private Root rootAfter;

    DynamicGroupValidatorProvider(@NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider, @NotNull SecurityProvider securityProvider, @NotNull Set<String> idpNamesWithDynamicGroups) {
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
        this.idpNamesWithDynamicGroups = idpNamesWithDynamicGroups;
        this.groupRootPath = (String)Preconditions.checkNotNull((Object)UserUtil.getAuthorizableRootPath((ConfigurationParameters)securityProvider.getParameters("org.apache.jackrabbit.oak.user"), (AuthorizableType)AuthorizableType.GROUP));
    }

    @NotNull
    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        if (this.idpNamesWithDynamicGroups.isEmpty()) {
            return DefaultValidator.INSTANCE;
        }
        this.rootBefore = this.rootProvider.createReadOnlyRoot(before);
        this.rootAfter = this.rootProvider.createReadOnlyRoot(after);
        return new SubtreeValidator((Validator)new DynamicGroupValidator(), (String[])Iterables.toArray((Iterable)PathUtils.elements((String)this.groupRootPath), String.class));
    }

    private class DynamicGroupValidator
    extends DefaultValidator {
        private Tree parentBefore;
        private Tree parentAfter;
        boolean isDynamicGroup = false;

        private DynamicGroupValidator() {
        }

        private DynamicGroupValidator(@NotNull Tree parentBefore, Tree parentAfter, boolean isDynamicGroup) {
            this.parentBefore = parentBefore;
            this.parentAfter = parentAfter;
            this.isDynamicGroup = isDynamicGroup;
        }

        private DynamicGroupValidator(Tree parentAfter, boolean isDynamicGroup) {
            this.parentAfter = parentAfter;
            this.isDynamicGroup = isDynamicGroup;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            if (this.isDynamicGroup && DynamicGroupUtil.isMemberProperty(after)) {
                throw this.commitFailedException(this.getParentAfter());
            }
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            if (this.isDynamicGroup && DynamicGroupUtil.isMemberProperty(before)) {
                HashSet refsBefore = Sets.newHashSet((Iterable)((Iterable)before.getValue(Type.STRINGS)));
                HashSet refsAfter = Sets.newHashSet((Iterable)((Iterable)after.getValue(Type.STRINGS)));
                refsAfter.removeAll(refsBefore);
                if (!refsAfter.isEmpty()) {
                    throw this.commitFailedException(this.getParentBefore());
                }
            }
        }

        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            Tree afterTree = DynamicGroupValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentAfter(), name, after);
            boolean dynamicGroupChild = this.isDynamicGroup(this, afterTree);
            if (dynamicGroupChild) {
                if (DynamicGroupUtil.isMembersType(afterTree)) {
                    throw this.commitFailedException(this.getParentAfter());
                }
                return new DynamicGroupValidator(afterTree, true);
            }
            if (!DynamicGroupUtil.isGroup(afterTree)) {
                return new DynamicGroupValidator(afterTree, false);
            }
            return null;
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) {
            Tree beforeTree = DynamicGroupValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentBefore(), name, before);
            Tree afterTree = DynamicGroupValidatorProvider.this.treeProvider.createReadOnlyTree(this.getParentAfter(), name, after);
            boolean dynamicGroupChild = this.isDynamicGroup(this, beforeTree);
            if (dynamicGroupChild || !DynamicGroupUtil.isGroup(beforeTree)) {
                return new DynamicGroupValidator(beforeTree, afterTree, dynamicGroupChild);
            }
            return null;
        }

        private boolean isDynamicGroup(@NotNull DynamicGroupValidator parentValidator, @NotNull Tree tree) {
            if (parentValidator.isDynamicGroup) {
                return true;
            }
            return this.isDynamicGroup(tree);
        }

        private boolean isDynamicGroup(@NotNull Tree tree) {
            if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.GROUP)) {
                PropertyState ps = tree.getProperty("rep:externalId");
                if (ps == null) {
                    return false;
                }
                String providerName = ExternalIdentityRef.fromString((String)ps.getValue(Type.STRING)).getProviderName();
                return providerName != null && DynamicGroupValidatorProvider.this.idpNamesWithDynamicGroups.contains(providerName);
            }
            return false;
        }

        @NotNull
        private Tree getParentBefore() {
            if (this.parentBefore == null) {
                this.parentBefore = DynamicGroupValidatorProvider.this.rootBefore.getTree(DynamicGroupValidatorProvider.this.groupRootPath);
            }
            return this.parentBefore;
        }

        @NotNull
        private Tree getParentAfter() {
            if (this.parentAfter == null) {
                this.parentAfter = DynamicGroupValidatorProvider.this.rootAfter.getTree(DynamicGroupValidatorProvider.this.groupRootPath);
            }
            return this.parentAfter;
        }

        @NotNull
        private CommitFailedException commitFailedException(@NotNull Tree tree) {
            String msg = String.format("Attempt to add members to dynamic group '%s' at '%s'", DynamicGroupUtil.findGroupIdInHierarchy(tree), tree.getPath());
            return new CommitFailedException("Constraint", 77, msg);
        }
    }
}

