/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalGroupPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncConfigTracker;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipService;
import org.jetbrains.annotations.NotNull;

class DynamicGroupMembershipService
implements DynamicMembershipService {
    private final SyncConfigTracker scTracker;

    public DynamicGroupMembershipService(@NotNull SyncConfigTracker scTracker) {
        this.scTracker = scTracker;
    }

    @NotNull
    public DynamicMembershipProvider getDynamicMembershipProvider(@NotNull Root root, @NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper) {
        if (this.scTracker.hasDynamicGroupsEnabled()) {
            return new ExternalGroupPrincipalProvider(root, userManager, namePathMapper, this.scTracker);
        }
        return DynamicMembershipProvider.EMPTY;
    }
}

