/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.monitor;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.monitor.ExternalIdentityMonitor;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;

public class ExternalIdentityMonitorImpl
implements ExternalIdentityMonitor {
    private final TimerStats syncTimer;
    private final MeterStats syncRetries;
    private final TimerStats syncIdTimer;
    private final MeterStats syncFailed;

    public ExternalIdentityMonitorImpl(@NotNull StatisticsProvider statisticsProvider) {
        this.syncTimer = statisticsProvider.getTimer("security.authentication.external.sync_external_identity.timer", StatsOptions.METRICS_ONLY);
        this.syncRetries = statisticsProvider.getMeter("security.authentication.external.sync_external_identity.retries", StatsOptions.DEFAULT);
        this.syncIdTimer = statisticsProvider.getTimer("security.authentication.external.sync_id.timer", StatsOptions.METRICS_ONLY);
        this.syncFailed = statisticsProvider.getMeter("security.authentication.external.sync.failed", StatsOptions.DEFAULT);
    }

    @Override
    public void doneSyncExternalIdentity(long timeTakenNanos, @NotNull SyncResult result, int retryCount) {
        this.syncTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        if (retryCount > 0) {
            this.syncRetries.mark((long)retryCount);
        }
    }

    @Override
    public void doneSyncId(long timeTakenNanos, @NotNull SyncResult result) {
        this.syncIdTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void syncFailed(@NotNull SyncException syncException) {
        this.syncFailed.mark();
    }
}

