/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.PrincipalNameResolver;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSyncContext
extends DefaultSyncContext {
    private static final Logger log = LoggerFactory.getLogger(DynamicSyncContext.class);

    public DynamicSyncContext(@NotNull DefaultSyncConfig config, @NotNull ExternalIdentityProvider idp, @NotNull UserManager userManager, @NotNull ValueFactory valueFactory) {
        super(config, idp, userManager, valueFactory);
    }

    public boolean convertToDynamicMembership(@NotNull Authorizable authorizable) throws RepositoryException {
        if (authorizable.isGroup() || !DynamicSyncContext.groupsSyncedBefore(authorizable)) {
            return false;
        }
        Collection<String> principalNames = this.clearGroupMembership(authorizable);
        authorizable.setProperty("rep:externalPrincipalNames", this.createValues(principalNames));
        return true;
    }

    @Override
    @NotNull
    public SyncResult sync(@NotNull ExternalIdentity identity) throws SyncException {
        if (identity instanceof ExternalUser) {
            return super.sync(identity);
        }
        if (identity instanceof ExternalGroup) {
            ExternalIdentityRef ref = identity.getExternalId();
            if (!this.isSameIDP(ref)) {
                this.warnForeign(identity);
                return new DefaultSyncResultImpl(new DefaultSyncedIdentity(identity.getId(), ref, true, -1L), SyncResult.Status.FOREIGN);
            }
            return this.sync((ExternalGroup)identity, ref);
        }
        throw new IllegalArgumentException("identity must be user or group but was: " + identity);
    }

    @NotNull
    private SyncResult sync(@NotNull ExternalGroup identity, @NotNull ExternalIdentityRef ref) throws SyncException {
        try {
            Group group = this.getAuthorizable(identity, Group.class);
            if (group != null) {
                return this.syncGroup(identity, group);
            }
            if (this.hasDynamicGroups()) {
                log.debug("ExternalGroup {}: synchronizing as dynamic group {}.", (Object)ref.getString(), (Object)identity.getId());
                group = this.createGroup(identity);
                DefaultSyncResultImpl res = this.syncGroup(identity, group);
                res.setStatus(SyncResult.Status.ADD);
                return res;
            }
            log.debug("ExternalGroup {}: Not synchronized as Group into the repository.", (Object)ref.getString());
            return new DefaultSyncResultImpl(new DefaultSyncedIdentity(identity.getId(), ref, true, -1L), SyncResult.Status.NOP);
        }
        catch (RepositoryException e) {
            throw new SyncException(e);
        }
    }

    @Override
    protected void syncMembership(@NotNull ExternalIdentity external, @NotNull Authorizable auth, long depth) throws RepositoryException {
        if (auth.isGroup()) {
            return;
        }
        boolean groupsSyncedBefore = DynamicSyncContext.groupsSyncedBefore(auth);
        if (groupsSyncedBefore && !this.enforceDynamicSync()) {
            super.syncMembership(external, auth, depth);
        } else {
            try {
                Iterable<ExternalIdentityRef> declaredGroupRefs = external.getDeclaredGroups();
                Map<ExternalIdentityRef, SyncEntry> map = this.collectSyncEntries(declaredGroupRefs, depth);
                this.setExternalPrincipalNames(auth, map.values());
                if (this.hasDynamicGroups() && depth > 0L) {
                    this.createDynamicGroups(map.values());
                }
                if (groupsSyncedBefore) {
                    this.clearGroupMembership(auth);
                }
            }
            catch (ExternalIdentityException e) {
                log.error("Failed to synchronize membership information for external identity {}", (Object)external.getId(), (Object)e);
            }
        }
    }

    @Override
    protected void applyMembership(@NotNull Authorizable member, @NotNull Set<String> groups) throws RepositoryException {
        log.debug("Dynamic membership sync enabled => omit setting auto-membership for {} ", (Object)member.getID());
    }

    private void setExternalPrincipalNames(@NotNull Authorizable authorizable, @NotNull Collection<SyncEntry> syncEntries) throws RepositoryException {
        Value[] vs;
        if (syncEntries.isEmpty()) {
            vs = new Value[]{};
        } else {
            Set principalsNames = syncEntries.stream().map(syncEntry -> syncEntry.principalName).collect(Collectors.toSet());
            vs = this.createValues(principalsNames);
        }
        authorizable.setProperty("rep:externalPrincipalNames", vs);
    }

    @NotNull
    private Map<ExternalIdentityRef, SyncEntry> collectSyncEntries(@NotNull Iterable<ExternalIdentityRef> declaredGroupRefs, long depth) throws RepositoryException, ExternalIdentityException {
        if (depth <= 0L) {
            return Collections.emptyMap();
        }
        HashMap<ExternalIdentityRef, SyncEntry> map = new HashMap<ExternalIdentityRef, SyncEntry>();
        this.collectSyncEntries(declaredGroupRefs, depth, map);
        return map;
    }

    private void collectSyncEntries(@NotNull Iterable<ExternalIdentityRef> declaredGroupRefs, long depth, @NotNull Map<ExternalIdentityRef, SyncEntry> map) throws ExternalIdentityException, RepositoryException {
        boolean shortcut = this.shortcut(depth);
        for (ExternalIdentityRef ref : Iterables.filter(declaredGroupRefs, this::isSameIDP)) {
            String principalName = null;
            Authorizable a = null;
            ExternalGroup externalGroup = null;
            if (shortcut) {
                principalName = ((PrincipalNameResolver)((Object)this.idp)).fromExternalIdentityRef(ref);
                a = this.userManager.getAuthorizable((Principal)new PrincipalImpl(principalName));
            } else {
                externalGroup = this.getExternalGroupFromRef(ref);
                if (externalGroup != null) {
                    principalName = externalGroup.getPrincipalName();
                    a = this.userManager.getAuthorizable(externalGroup.getId());
                    if (depth > 1L) {
                        this.collectSyncEntries(externalGroup.getDeclaredGroups(), depth - 1L, map);
                    }
                }
            }
            if (principalName == null || this.isConflictingGroup(a, principalName)) continue;
            map.put(ref, new SyncEntry(principalName, externalGroup, (Group)a));
        }
    }

    private boolean shortcut(long depth) {
        return depth <= 1L && this.idp instanceof PrincipalNameResolver && !this.hasDynamicGroups();
    }

    private boolean isConflictingGroup(@Nullable Authorizable authorizable, @NotNull String principalName) throws RepositoryException {
        if (authorizable == null) {
            return false;
        }
        if (!authorizable.isGroup()) {
            log.warn("Existing user '{}' collides with external group defined by IDP '{}'.", (Object)authorizable.getID(), (Object)this.idp.getName());
            return true;
        }
        if (!this.isSameIDP(authorizable)) {
            this.warnForeignExisting(authorizable, true);
            return true;
        }
        if (!principalName.equals(authorizable.getPrincipal().getName())) {
            log.warn("Existing group with id '{}' doesn't have matching principal name. found '{}', expected '{}', IDP '{}'.", new Object[]{authorizable.getID(), authorizable.getPrincipal().getName(), principalName, this.idp.getName()});
            return true;
        }
        return false;
    }

    private void createDynamicGroups(@NotNull Iterable<SyncEntry> syncEntries) throws RepositoryException {
        for (SyncEntry syncEntry : syncEntries) {
            Preconditions.checkNotNull((Object)syncEntry.externalGroup, (Object)"Cannot create dynamic group from null ExternalIdentity.");
            Group gr = syncEntry.group;
            if (gr == null) {
                gr = this.createGroup(syncEntry.externalGroup);
            }
            this.syncGroup(syncEntry.externalGroup, gr);
        }
    }

    @NotNull
    private Collection<String> clearGroupMembership(@NotNull Authorizable authorizable) throws RepositoryException {
        HashSet<String> groupPrincipalNames = new HashSet<String>();
        HashSet<Group> toRemove = new HashSet<Group>();
        this.clearGroupMembership(authorizable, groupPrincipalNames, toRemove);
        for (Group group : toRemove) {
            group.remove();
        }
        return groupPrincipalNames;
    }

    private void clearGroupMembership(@NotNull Authorizable authorizable, @NotNull Set<String> groupPrincipalNames, @NotNull Set<Group> toRemove) throws RepositoryException {
        Iterator grpIter = authorizable.declaredMemberOf();
        Set<String> autoMembership = (authorizable.isGroup() ? this.config.group() : this.config.user()).getAutoMembership(authorizable);
        while (grpIter.hasNext()) {
            Group grp = (Group)grpIter.next();
            if (this.isSameIDP((Authorizable)grp)) {
                groupPrincipalNames.add(grp.getPrincipal().getName());
                grp.removeMember(authorizable);
                this.clearGroupMembership((Authorizable)grp, groupPrincipalNames, toRemove);
                if (!this.clearGroup(grp)) continue;
                toRemove.add(grp);
                continue;
            }
            if (autoMembership.contains(grp.getID())) {
                grp.removeMember(authorizable);
                this.clearGroupMembership((Authorizable)grp, groupPrincipalNames, toRemove);
                continue;
            }
            if (DynamicSyncContext.isEveryone(grp)) continue;
            log.warn("Ignoring unexpected membership of '{}' in group '{}' crossing IDP boundary.", (Object)authorizable.getID(), (Object)grp.getID());
        }
    }

    private boolean hasDynamicGroups() {
        return this.config.group().getDynamicGroups();
    }

    private boolean enforceDynamicSync() {
        return this.config.user().getEnforceDynamicMembership() || this.hasDynamicGroups();
    }

    private boolean clearGroup(@NotNull Group group) throws RepositoryException {
        if (this.hasDynamicGroups()) {
            return false;
        }
        return !group.getDeclaredMembers().hasNext();
    }

    private static boolean groupsSyncedBefore(@NotNull Authorizable authorizable) throws RepositoryException {
        return authorizable.hasProperty("rep:lastSynced") && !authorizable.hasProperty("rep:externalPrincipalNames");
    }

    private static boolean isEveryone(@NotNull Group group) {
        try {
            return "everyone".equals(group.getPrincipal().getName());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private static class SyncEntry {
        private final String principalName;
        private final ExternalGroup externalGroup;
        private final Group group;

        private SyncEntry(@NotNull String principalName, @Nullable ExternalGroup externalGroup, @Nullable Group group) {
            this.principalName = principalName;
            this.externalGroup = externalGroup;
            this.group = group;
        }
    }
}

