/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipAware;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncConfigImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DynamicSyncContext;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class DefaultSyncHandler
implements SyncHandler,
AutoMembershipAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncHandler.class);
    private DefaultSyncConfig config;
    private AutoMembershipTracker autoMembershipTracker;

    public DefaultSyncHandler() {
    }

    public DefaultSyncHandler(DefaultSyncConfig config) {
        this.config = config;
    }

    @Activate
    public void activate(@NotNull BundleContext bundleContext, Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = DefaultSyncConfigImpl.of(cfg);
        this.autoMembershipTracker = new AutoMembershipTracker();
        this.autoMembershipTracker.start((Whiteboard)new OsgiWhiteboard(bundleContext));
        this.config.user().setAutoMembershipConfig(this.autoMembershipTracker);
        this.config.group().setAutoMembershipConfig(this.autoMembershipTracker);
    }

    @Deactivate
    public void deactivate() {
        if (this.autoMembershipTracker != null) {
            this.autoMembershipTracker.stop();
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    @Override
    @NotNull
    public SyncContext createContext(@NotNull ExternalIdentityProvider idp, @NotNull UserManager userManager, @NotNull ValueFactory valueFactory) {
        if (this.config.user().getDynamicMembership()) {
            return new DynamicSyncContext(this.config, idp, userManager, valueFactory);
        }
        return new DefaultSyncContext(this.config, idp, userManager, valueFactory);
    }

    @Override
    public SyncedIdentity findIdentity(@NotNull UserManager userManager, @NotNull String id) throws RepositoryException {
        return DefaultSyncContext.createSyncedIdentity(userManager.getAuthorizable(id));
    }

    @Override
    public boolean requiresSync(@NotNull SyncedIdentity identity) {
        if (identity.getExternalIdRef() == null || identity.lastSynced() < 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        long expirationTime = identity.isGroup() ? this.config.group().getExpirationTime() : this.config.user().getExpirationTime();
        return now - identity.lastSynced() > expirationTime;
    }

    @Override
    @NotNull
    public Iterator<SyncedIdentity> listIdentities(@NotNull UserManager userManager) throws RepositoryException {
        final Iterator iter = userManager.findAuthorizables("rep:externalId", null);
        return new AbstractLazyIterator<SyncedIdentity>(){

            @Nullable
            protected SyncedIdentity getNext() {
                while (iter.hasNext()) {
                    try {
                        DefaultSyncedIdentity id = DefaultSyncContext.createSyncedIdentity((Authorizable)iter.next());
                        if (id == null || id.getExternalIdRef() == null) continue;
                        return id;
                    }
                    catch (RepositoryException e) {
                        log.error("Error while fetching authorizables", (Throwable)e);
                        break;
                    }
                }
                return null;
            }
        };
    }

    @Override
    @NotNull
    public AutoMembershipConfig getAutoMembershipConfig() {
        return this.autoMembershipTracker == null || this.autoMembershipTracker.isEmpty() ? AutoMembershipConfig.EMPTY : this.autoMembershipTracker;
    }

    private final class AutoMembershipTracker
    extends AbstractServiceTracker<AutoMembershipConfig>
    implements AutoMembershipConfig {
        public AutoMembershipTracker() {
            super(AutoMembershipConfig.class, Collections.singletonMap("sync.handlerName", DefaultSyncHandler.this.getName()));
        }

        private boolean isEmpty() {
            return this.getServices().isEmpty();
        }

        @Override
        public String getName() {
            return DefaultSyncHandler.this.getName();
        }

        @Override
        @NotNull
        public Set<String> getAutoMembership(@NotNull Authorizable authorizable) {
            HashSet<String> groupIds = new HashSet<String>();
            this.getServices().forEach(autoMembershipConfig -> groupIds.addAll(autoMembershipConfig.getAutoMembership(authorizable)));
            return groupIds;
        }

        @Override
        public Iterator<Authorizable> getAutoMembers(@NotNull UserManager userManager, @NotNull Group group) {
            return Iterators.concat(this.getServices().stream().map(autoMembershipConfig -> autoMembershipConfig.getAutoMembers(userManager, group)).iterator());
        }
    }
}

