/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component(label="Apache Jackrabbit Oak LDAP Identity Provider", name="org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentityProvider", configurationFactory=true, metatype=true, ds=false)
public class LdapProviderConfig {
    public static final String PARAM_NAME_DEFAULT = "ldap";
    @Property(label="LDAP Provider Name", description="Name of this LDAP provider configuration. This is used to reference this provider by the login modules.", value={"ldap"})
    public static final String PARAM_NAME = "provider.name";
    public static final String PARAM_LDAP_HOST_DEFAULT = "localhost";
    @Property(label="LDAP Server Hostname", description="Hostname of the LDAP server", value={"localhost"})
    public static final String PARAM_LDAP_HOST = "host.name";
    public static final int PARAM_LDAP_PORT_DEFAULT = 389;
    @Property(label="LDAP Server Port", description="Port of the LDAP server", intValue={389})
    public static final String PARAM_LDAP_PORT = "host.port";
    public static final boolean PARAM_USE_SSL_DEFAULT = false;
    @Property(label="Use SSL", description="Indicates if an SSL (LDAPs) connection should be used.", boolValue={false})
    public static final String PARAM_USE_SSL = "host.ssl";
    public static final boolean PARAM_USE_TLS_DEFAULT = false;
    @Property(label="Use TLS", description="Indicates if TLS should be started on connections.", boolValue={false})
    public static final String PARAM_USE_TLS = "host.tls";
    public static final boolean PARAM_NO_CERT_CHECK_DEFAULT = false;
    @Property(label="Disable certificate checking", description="Indicates if server certificate validation should be disabled.", boolValue={false})
    public static final String PARAM_NO_CERT_CHECK = "host.noCertCheck";
    @Property(label="Enabled Protocols", description="Allows to explicitly set the enabled protocols on the LdapConnectionConfig.", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_ENABLED_PROTOCOLS = "host.enabledProtocols";
    public static final String PARAM_BIND_DN_DEFAULT = "";
    @Property(label="Bind DN", description="DN of the user for authentication. Leave empty for anonymous bind.", value={""})
    public static final String PARAM_BIND_DN = "bind.dn";
    public static final String PARAM_BIND_PASSWORD_DEFAULT = "";
    @Property(label="Bind Password", description="Password of the user for authentication.", passwordValue={""})
    public static final String PARAM_BIND_PASSWORD = "bind.password";
    public static final String PARAM_SEARCH_TIMEOUT_DEFAULT = "60s";
    @Property(label="Search Timeout", description="Time in until a search times out (eg: '1s' or '1m 30s').", value={"60s"})
    public static final String PARAM_SEARCH_TIMEOUT = "searchTimeout";
    public static final int PARAM_ADMIN_POOL_MAX_ACTIVE_DEFAULT = 8;
    @Property(label="Admin pool max active", description="The max active size of the admin connection pool.", longValue={8L})
    public static final String PARAM_ADMIN_POOL_MAX_ACTIVE = "adminPool.maxActive";
    public static final boolean PARAM_ADMIN_POOL_LOOKUP_ON_VALIDATE_DEFAULT = true;
    @Property(label="Admin pool lookup on validate", description="Indicates an ROOT DSE lookup is performed to test if the connection is still valid when taking it out of the pool.", boolValue={true})
    public static final String PARAM_ADMIN_POOL_LOOKUP_ON_VALIDATE = "adminPool.lookupOnValidate";
    public static final String PARAM_ADMIN_POOL_MIN_EVICTABLE_IDLE_TIME_DEFAULT = "-1";
    @Property(label="Admin pool min evictable idle time", description="The minimum amount of time a connection from the admin pool must be idle before becoming eligible for eviction by the idle object evictor, if running (eg: '1m 30s'). When non-positive, no connections will be evicted from the pool due to idle time alone.", value={"-1"})
    public static final String PARAM_ADMIN_POOL_MIN_EVICTABLE_IDLE_TIME = "adminPool.minEvictableIdleTime";
    public static final String PARAM_ADMIN_POOL_TIME_BETWEEN_EVICTION_RUNS_DEFAULT = "-1";
    @Property(label="Time interval to sleep between evictor runs for the admin pool", description="Time interval to sleep between runs of the idle object evictor thread for the admin pool (eg: '1m 30s'). When non-positive, no idle object evictor thread will be run.", value={"-1"})
    public static final String PARAM_ADMIN_POOL_TIME_BETWEEN_EVICTION_RUNS = "adminPool.timeBetweenEvictionRuns";
    public static final int PARAM_ADMIN_POOL_NUM_TESTS_PER_EVICTION_RUN_DEFAULT = 3;
    @Property(label="Max number of objects to be tested per run of the idle object evictor for the admin pool", description="The max number of objects to examine during each run of the idle object evictor thread for the admin pool (if any)", intValue={3})
    public static final String PARAM_ADMIN_POOL_NUM_TESTS_PER_EVICTION_RUN = "adminPool.numTestsPerEvictionRun";
    public static final int PARAM_USER_POOL_MAX_ACTIVE_DEFAULT = 8;
    @Property(label="User pool max active", description="The max active size of the user connection pool.", longValue={8L})
    public static final String PARAM_USER_POOL_MAX_ACTIVE = "userPool.maxActive";
    public static final boolean PARAM_USER_POOL_LOOKUP_ON_VALIDATE_DEFAULT = true;
    @Property(label="User pool lookup on validate", description="Indicates an ROOT DSE lookup is performed to test if the connection is still valid when taking it out of the pool.", boolValue={true})
    public static final String PARAM_USER_POOL_LOOKUP_ON_VALIDATE = "userPool.lookupOnValidate";
    public static final String PARAM_USER_POOL_MIN_EVICTABLE_IDLE_TIME_DEFAULT = "-1";
    @Property(label="User pool min evictable idle time", description="The minimum amount of time a connection from the user pool must be idle before becoming eligible for eviction by the idle object evictor, if running (eg: '1m 30s'). When non-positive, no connections will be evicted from the pool due to idle time alone.", value={"-1"})
    public static final String PARAM_USER_POOL_MIN_EVICTABLE_IDLE_TIME = "userPool.minEvictableIdleTime";
    public static final String PARAM_USER_POOL_TIME_BETWEEN_EVICTION_RUNS_DEFAULT = "-1";
    @Property(label="Time interval to sleep between evictor runs for the user pool", description="Time interval to sleep between runs of the idle object evictor thread for the user pool (eg: '1m 30s'). When non-positive, no idle object evictor thread will be run.", value={"-1"})
    public static final String PARAM_USER_POOL_TIME_BETWEEN_EVICTION_RUNS = "userPool.timeBetweenEvictionRuns";
    public static final int PARAM_USER_POOL_NUM_TESTS_PER_EVICTION_RUN_DEFAULT = 3;
    @Property(label="Max number of objects to be tested per run of the idle object evictor for the user pool", description="The max number of objects to examine during each run of the idle object evictor thread for the user pool (if any)", intValue={3})
    public static final String PARAM_USER_POOL_NUM_TESTS_PER_EVICTION_RUN = "userPool.numTestsPerEvictionRun";
    public static final String PARAM_USER_BASE_DN_DEFAULT = "ou=people,o=example,dc=com";
    @Property(label="User base DN", description="The base DN for user searches.", value={"ou=people,o=example,dc=com"})
    public static final String PARAM_USER_BASE_DN = "user.baseDN";
    public static final String[] PARAM_USER_OBJECTCLASS_DEFAULT = new String[]{"person"};
    @Property(label="User object classes", description="The list of object classes an user entry must contain.", value={"person"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_OBJECTCLASS = "user.objectclass";
    public static final String PARAM_USER_ID_ATTRIBUTE_DEFAULT = "uid";
    @Property(label="User id attribute", description="Name of the attribute that contains the user id.", value={"uid"})
    public static final String PARAM_USER_ID_ATTRIBUTE = "user.idAttribute";
    public static final String PARAM_USER_EXTRA_FILTER_DEFAULT = "";
    @Property(label="User extra filter", description="Extra LDAP filter to use when searching for users. The final filter isformatted like: '(&(<idAttr>=<userId>)(objectclass=<objectclass>)<extraFilter>)'", value={""})
    public static final String PARAM_USER_EXTRA_FILTER = "user.extraFilter";
    public static final boolean PARAM_USER_MAKE_DN_PATH_DEFAULT = false;
    @Property(label="User DN paths", description="Controls if the DN should be used for calculating a portion of the intermediate path.", boolValue={false})
    public static final String PARAM_USER_MAKE_DN_PATH = "user.makeDnPath";
    public static final String PARAM_GROUP_BASE_DN_DEFAULT = "ou=groups,o=example,dc=com";
    @Property(label="Group base DN", description="The base DN for group searches.", value={"ou=groups,o=example,dc=com"})
    public static final String PARAM_GROUP_BASE_DN = "group.baseDN";
    public static final String[] PARAM_GROUP_OBJECTCLASS_DEFAULT = new String[]{"groupOfUniqueNames"};
    @Property(label="Group object classes", description="The list of object classes a group entry must contain.", value={"groupOfUniqueNames"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_OBJECTCLASS = "group.objectclass";
    public static final String PARAM_GROUP_NAME_ATTRIBUTE_DEFAULT = "cn";
    @Property(label="Group name attribute", description="Name of the attribute that contains the group name.", value={"cn"})
    public static final String PARAM_GROUP_NAME_ATTRIBUTE = "group.nameAttribute";
    public static final String PARAM_GROUP_EXTRA_FILTER_DEFAULT = "";
    @Property(label="Group extra filter", description="Extra LDAP filter to use when searching for groups. The final filter isformatted like: '(&(<nameAttr>=<groupName>)(objectclass=<objectclass>)<extraFilter>)'", value={""})
    public static final String PARAM_GROUP_EXTRA_FILTER = "group.extraFilter";
    public static final boolean PARAM_GROUP_MAKE_DN_PATH_DEFAULT = false;
    @Property(label="Group DN paths", description="Controls if the DN should be used for calculating a portion of the intermediate path.", boolValue={false})
    public static final String PARAM_GROUP_MAKE_DN_PATH = "group.makeDnPath";
    public static final String PARAM_GROUP_MEMBER_ATTRIBUTE_DEFAULT = "uniquemember";
    @Property(label="Group member attribute", description="Group attribute that contains the member(s) of a group.", value={"uniquemember"})
    public static final String PARAM_GROUP_MEMBER_ATTRIBUTE = "group.memberAttribute";
    public static final boolean PARAM_USE_UID_FOR_EXT_ID_DEFAULT = false;
    @Property(label="Use user id for external ids", description="If enabled, the value of the user id (resp. group name) attribute will be used to create external identifiers. Leave disabled to use the DN instead.", boolValue={false})
    public static final String PARAM_USE_UID_FOR_EXT_ID = "useUidForExtId";
    public static final String[] PARAM_CUSTOM_ATTRIBUTES_DEFAULT = new String[0];
    @Property(label="Custom Attributes", description="Attributes retrieved when looking up LDAP entries. Leave empty to retrieve all attributes.", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_CUSTOM_ATTRIBUTES = "customattributes";
    private String name = "ldap";
    private String hostname = "localhost";
    private int port = 389;
    private boolean useSSL = false;
    private boolean useTLS = false;
    private boolean noCertCheck = false;
    private String[] enabledProtocols = null;
    private String bindDN = "";
    private String bindPassword = "";
    private long searchTimeout;
    private String groupMemberAttribute;
    private boolean useUidForExtId;
    private String memberOfFilterTemplate;
    private String[] customAttributes;
    private final PoolConfig adminPoolConfig;
    private final PoolConfig userPoolConfig;
    private final Identity userConfig;
    private final Identity groupConfig;

    public LdapProviderConfig() {
        this.searchTimeout = ConfigurationParameters.Milliseconds.of((String)PARAM_SEARCH_TIMEOUT_DEFAULT).value;
        this.groupMemberAttribute = PARAM_GROUP_MEMBER_ATTRIBUTE;
        this.useUidForExtId = false;
        this.customAttributes = PARAM_CUSTOM_ATTRIBUTES_DEFAULT;
        this.adminPoolConfig = new PoolConfig().setMaxActive(8);
        this.userPoolConfig = new PoolConfig().setMaxActive(8);
        this.userConfig = new Identity().setBaseDN(PARAM_USER_BASE_DN_DEFAULT).setExtraFilter("").setIdAttribute(PARAM_USER_ID_ATTRIBUTE_DEFAULT).setMakeDnPath(false).setObjectClasses(PARAM_USER_OBJECTCLASS_DEFAULT);
        this.groupConfig = new Identity().setBaseDN(PARAM_GROUP_BASE_DN_DEFAULT).setExtraFilter("").setIdAttribute(PARAM_GROUP_NAME_ATTRIBUTE_DEFAULT).setMakeDnPath(false).setObjectClasses(PARAM_GROUP_OBJECTCLASS_DEFAULT);
    }

    public static LdapProviderConfig of(ConfigurationParameters params) {
        String[] enabledProtocols;
        LdapProviderConfig cfg = new LdapProviderConfig().setName((String)params.getConfigValue(PARAM_NAME, (Object)PARAM_NAME_DEFAULT)).setHostname((String)params.getConfigValue(PARAM_LDAP_HOST, (Object)PARAM_LDAP_HOST_DEFAULT)).setPort((Integer)params.getConfigValue(PARAM_LDAP_PORT, (Object)389)).setUseSSL((Boolean)params.getConfigValue(PARAM_USE_SSL, (Object)false)).setUseTLS((Boolean)params.getConfigValue(PARAM_USE_TLS, (Object)false)).setNoCertCheck((Boolean)params.getConfigValue(PARAM_NO_CERT_CHECK, (Object)false)).setBindDN((String)params.getConfigValue(PARAM_BIND_DN, (Object)"")).setBindPassword((String)params.getConfigValue(PARAM_BIND_PASSWORD, (Object)"")).setGroupMemberAttribute((String)params.getConfigValue(PARAM_GROUP_MEMBER_ATTRIBUTE, (Object)PARAM_GROUP_MEMBER_ATTRIBUTE_DEFAULT)).setCustomAttributes((String[])params.getConfigValue(PARAM_CUSTOM_ATTRIBUTES, (Object)PARAM_CUSTOM_ATTRIBUTES_DEFAULT)).setUseUidForExtId((Boolean)params.getConfigValue(PARAM_USE_UID_FOR_EXT_ID, (Object)false));
        ConfigurationParameters.Milliseconds ms = ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue(PARAM_SEARCH_TIMEOUT, (Object)PARAM_SEARCH_TIMEOUT_DEFAULT)));
        if (ms != null) {
            cfg.setSearchTimeout(ms.value);
        }
        cfg.getUserConfig().setBaseDN((String)params.getConfigValue(PARAM_USER_BASE_DN, (Object)PARAM_USER_BASE_DN)).setIdAttribute((String)params.getConfigValue(PARAM_USER_ID_ATTRIBUTE, (Object)PARAM_USER_ID_ATTRIBUTE_DEFAULT)).setExtraFilter((String)params.getConfigValue(PARAM_USER_EXTRA_FILTER, (Object)"")).setObjectClasses((String[])params.getConfigValue(PARAM_USER_OBJECTCLASS, (Object)PARAM_USER_OBJECTCLASS_DEFAULT)).setMakeDnPath((Boolean)params.getConfigValue(PARAM_USER_MAKE_DN_PATH, (Object)false));
        cfg.getGroupConfig().setBaseDN((String)params.getConfigValue(PARAM_GROUP_BASE_DN, (Object)PARAM_GROUP_BASE_DN)).setIdAttribute((String)params.getConfigValue(PARAM_GROUP_NAME_ATTRIBUTE, (Object)PARAM_GROUP_NAME_ATTRIBUTE_DEFAULT)).setExtraFilter((String)params.getConfigValue(PARAM_GROUP_EXTRA_FILTER, (Object)"")).setObjectClasses((String[])params.getConfigValue(PARAM_GROUP_OBJECTCLASS, (Object)PARAM_GROUP_OBJECTCLASS_DEFAULT)).setMakeDnPath((Boolean)params.getConfigValue(PARAM_GROUP_MAKE_DN_PATH, (Object)false));
        ConfigurationParameters.Milliseconds msMeitAdmin = ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue(PARAM_ADMIN_POOL_MIN_EVICTABLE_IDLE_TIME, (Object)"-1")));
        ConfigurationParameters.Milliseconds msTberAdmin = ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue(PARAM_ADMIN_POOL_TIME_BETWEEN_EVICTION_RUNS, (Object)"-1")));
        cfg.getAdminPoolConfig().setLookupOnValidate((Boolean)params.getConfigValue(PARAM_ADMIN_POOL_LOOKUP_ON_VALIDATE, (Object)true)).setMaxActive((Integer)params.getConfigValue(PARAM_ADMIN_POOL_MAX_ACTIVE, (Object)8)).setNumTestsPerEvictionRun((Integer)params.getConfigValue(PARAM_ADMIN_POOL_NUM_TESTS_PER_EVICTION_RUN, (Object)3));
        if (msMeitAdmin != null) {
            cfg.getAdminPoolConfig().setMinEvictableIdleTimeMillis(msMeitAdmin.value);
        }
        if (msTberAdmin != null) {
            cfg.getAdminPoolConfig().setTimeBetweenEvictionRunsMillis(msTberAdmin.value);
        }
        ConfigurationParameters.Milliseconds msMeitUser = ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue(PARAM_USER_POOL_MIN_EVICTABLE_IDLE_TIME, (Object)"-1")));
        ConfigurationParameters.Milliseconds msTberUser = ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue(PARAM_USER_POOL_TIME_BETWEEN_EVICTION_RUNS, (Object)"-1")));
        cfg.getUserPoolConfig().setLookupOnValidate((Boolean)params.getConfigValue(PARAM_USER_POOL_LOOKUP_ON_VALIDATE, (Object)true)).setMaxActive((Integer)params.getConfigValue(PARAM_USER_POOL_MAX_ACTIVE, (Object)8)).setNumTestsPerEvictionRun((Integer)params.getConfigValue(PARAM_USER_POOL_NUM_TESTS_PER_EVICTION_RUN, (Object)3));
        if (msMeitUser != null) {
            cfg.getUserPoolConfig().setMinEvictableIdleTimeMillis(msMeitUser.value);
        }
        if (msTberUser != null) {
            cfg.getUserPoolConfig().setTimeBetweenEvictionRunsMillis(msTberUser.value);
        }
        if ((enabledProtocols = (String[])params.getConfigValue(PARAM_ENABLED_PROTOCOLS, (Object)new String[0])).length > 0) {
            cfg.setEnabledProtocols(enabledProtocols);
        }
        return cfg;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public LdapProviderConfig setName(@NotNull String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    @NotNull
    public LdapProviderConfig setHostname(@NotNull String hostname) {
        this.hostname = hostname;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public LdapProviderConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    @NotNull
    public LdapProviderConfig setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        return this;
    }

    public boolean useTLS() {
        return this.useTLS;
    }

    @NotNull
    public LdapProviderConfig setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
        return this;
    }

    public boolean noCertCheck() {
        return this.noCertCheck;
    }

    @NotNull
    public LdapProviderConfig setNoCertCheck(boolean noCertCheck) {
        this.noCertCheck = noCertCheck;
        return this;
    }

    @Nullable
    public String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    @NotNull
    public LdapProviderConfig setEnabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    @Nullable
    public String getBindDN() {
        return this.bindDN;
    }

    @NotNull
    public LdapProviderConfig setBindDN(@Nullable String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    @Nullable
    public String getBindPassword() {
        return this.bindPassword;
    }

    @NotNull
    public LdapProviderConfig setBindPassword(@Nullable String bindPassword) {
        this.bindPassword = bindPassword;
        return this;
    }

    public long getSearchTimeout() {
        return this.searchTimeout;
    }

    @NotNull
    public LdapProviderConfig setSearchTimeout(long searchTimeout) {
        this.searchTimeout = searchTimeout;
        return this;
    }

    @NotNull
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    @NotNull
    public LdapProviderConfig setGroupMemberAttribute(@NotNull String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
        return this;
    }

    public boolean getUseUidForExtId() {
        return this.useUidForExtId;
    }

    @NotNull
    public LdapProviderConfig setUseUidForExtId(boolean useUidForExtId) {
        this.useUidForExtId = useUidForExtId;
        return this;
    }

    @NotNull
    public String[] getCustomAttributes() {
        return this.customAttributes;
    }

    @NotNull
    public LdapProviderConfig setCustomAttributes(@NotNull String[] customAttributes) {
        this.customAttributes = this.removeEmptyStrings(customAttributes);
        return this;
    }

    public String getMemberOfSearchFilter(@NotNull String dn) {
        if (this.memberOfFilterTemplate == null) {
            StringBuilder filter = new StringBuilder("(&(").append(this.groupMemberAttribute).append("=%s)");
            for (String objectClass : this.groupConfig.objectClasses) {
                filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
            }
            if (this.groupConfig.extraFilter != null && this.groupConfig.extraFilter.length() > 0) {
                filter.append(this.groupConfig.extraFilter);
            }
            filter.append(')');
            this.memberOfFilterTemplate = filter.toString();
        }
        return String.format(this.memberOfFilterTemplate, LdapProviderConfig.encodeFilterValue(dn));
    }

    @NotNull
    public Identity getUserConfig() {
        return this.userConfig;
    }

    @NotNull
    public Identity getGroupConfig() {
        return this.groupConfig;
    }

    @NotNull
    public PoolConfig getAdminPoolConfig() {
        return this.adminPoolConfig;
    }

    @NotNull
    public PoolConfig getUserPoolConfig() {
        return this.userPoolConfig;
    }

    public static String encodeFilterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            String replace;
            char ch = value.charAt(i);
            switch (ch) {
                case '*': {
                    replace = "\\2A";
                    break;
                }
                case '(': {
                    replace = "\\28";
                    break;
                }
                case ')': {
                    replace = "\\29";
                    break;
                }
                case '\\': {
                    replace = "\\5C";
                    break;
                }
                case '\u0000': {
                    replace = "\\00";
                    break;
                }
                default: {
                    replace = null;
                }
            }
            if (replace != null) {
                if (sb == null) {
                    sb = new StringBuilder(value.length() * 2);
                    sb.append(value.substring(0, i));
                }
                sb.append(replace);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : sb.toString();
    }

    private String[] removeEmptyStrings(@NotNull String[] params) {
        List<String> list = Arrays.asList(params);
        if (!list.contains("")) {
            return params;
        }
        LinkedList<String> resultList = new LinkedList<String>(list);
        while (resultList.contains("")) {
            resultList.remove("");
        }
        String[] result = new String[resultList.size()];
        return resultList.toArray(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LdapProviderConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", useSSL=").append(this.useSSL);
        sb.append(", useTLS=").append(this.useTLS);
        sb.append(", noCertCheck=").append(this.noCertCheck);
        sb.append(", enabledProtocols=").append(this.enabledProtocols);
        sb.append(", bindDN='").append(this.bindDN).append('\'');
        sb.append(", bindPassword='***'");
        sb.append(", searchTimeout=").append(this.searchTimeout);
        sb.append(", groupMemberAttribute='").append(this.groupMemberAttribute).append('\'');
        sb.append(", useUidForExtId='").append(this.useUidForExtId).append('\'');
        sb.append(", memberOfFilterTemplate='").append(this.memberOfFilterTemplate).append('\'');
        sb.append(", adminPoolConfig=").append(this.adminPoolConfig);
        sb.append(", userPoolConfig=").append(this.userPoolConfig);
        sb.append(", userConfig=").append(this.userConfig);
        sb.append(", groupConfig=").append(this.groupConfig);
        sb.append('}');
        return sb.toString();
    }

    public static class PoolConfig {
        private int maxActiveSize;
        private boolean lookupOnValidate;
        private long minEvictableIdleTimeMillis;
        private long timeBetweenEvictionRunsMillis;
        private int numTestsPerEvictionRun;

        public int getMaxActive() {
            return this.maxActiveSize;
        }

        @NotNull
        public PoolConfig setMaxActive(int maxActive) {
            this.maxActiveSize = maxActive;
            return this;
        }

        public boolean lookupOnValidate() {
            return this.lookupOnValidate;
        }

        @NotNull
        public PoolConfig setLookupOnValidate(boolean lookupOnValidate) {
            this.lookupOnValidate = lookupOnValidate;
            return this;
        }

        public long getMinEvictableIdleTimeMillis() {
            return this.minEvictableIdleTimeMillis;
        }

        public PoolConfig setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public long getTimeBetweenEvictionRunsMillis() {
            return this.timeBetweenEvictionRunsMillis;
        }

        public PoolConfig setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public int getNumTestsPerEvictionRun() {
            return this.numTestsPerEvictionRun;
        }

        public PoolConfig setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
            this.numTestsPerEvictionRun = numTestsPerEvictionRun;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PoolConfig{");
            sb.append("maxActiveSize=").append(this.maxActiveSize);
            sb.append(", lookupOnValidate=").append(this.lookupOnValidate);
            sb.append(", minEvictableIdleTimeMillis=").append(this.minEvictableIdleTimeMillis);
            sb.append(", timeBetweenEvictionRunsMillis=").append(this.timeBetweenEvictionRunsMillis);
            sb.append(", numTestsPerEvictionRun=").append(this.numTestsPerEvictionRun);
            sb.append('}');
            return sb.toString();
        }
    }

    public class Identity {
        private String baseDN;
        private String[] objectClasses;
        private String idAttribute;
        private String[] customAttributes = new String[0];
        private String extraFilter;
        private String filterTemplate;
        private boolean makeDnPath;

        @NotNull
        public String getBaseDN() {
            return this.baseDN;
        }

        @NotNull
        public Identity setBaseDN(@NotNull String baseDN) {
            this.baseDN = baseDN;
            return this;
        }

        @NotNull
        public String[] getObjectClasses() {
            return this.objectClasses;
        }

        @NotNull
        public Identity setObjectClasses(String ... objectClasses) {
            this.objectClasses = objectClasses;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        @NotNull
        public String getIdAttribute() {
            return this.idAttribute;
        }

        @NotNull
        public Identity setIdAttribute(@NotNull String idAttribute) {
            this.idAttribute = idAttribute;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        @Nullable
        public String getExtraFilter() {
            return this.extraFilter;
        }

        @NotNull
        public Identity setExtraFilter(@Nullable String extraFilter) {
            this.extraFilter = extraFilter;
            this.filterTemplate = null;
            LdapProviderConfig.this.memberOfFilterTemplate = null;
            return this;
        }

        public boolean makeDnPath() {
            return this.makeDnPath;
        }

        @NotNull
        public Identity setMakeDnPath(boolean makeDnPath) {
            this.makeDnPath = makeDnPath;
            return this;
        }

        @NotNull
        public String getSearchFilter(@NotNull String id) {
            if (this.filterTemplate == null) {
                StringBuilder filter = new StringBuilder("(&(").append(this.idAttribute).append("=%s)");
                for (String objectClass : this.objectClasses) {
                    filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
                }
                if (this.extraFilter != null && this.extraFilter.length() > 0) {
                    filter.append(this.extraFilter);
                }
                filter.append(')');
                this.filterTemplate = filter.toString();
            }
            return String.format(this.filterTemplate, LdapProviderConfig.encodeFilterValue(id));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Identity{");
            sb.append("baseDN='").append(this.baseDN).append('\'');
            sb.append(", objectClasses=").append(Arrays.toString(this.objectClasses));
            sb.append(", idAttribute='").append(this.idAttribute).append('\'');
            sb.append(", userAttributes='").append(Arrays.toString(this.customAttributes));
            sb.append(", extraFilter='").append(this.extraFilter).append('\'');
            sb.append(", filterTemplate='").append(this.filterTemplate).append('\'');
            sb.append(", makeDnPath=").append(this.makeDnPath);
            sb.append('}');
            return sb.toString();
        }
    }
}

