/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.ldap.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.LoginException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.AbstractPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionValidator;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.api.LookupLdapConnectionValidator;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.commons.DebugTimer;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapGroup;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapIdentity;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapProviderConfig;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.LdapUser;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.PoolableUnboundConnectionFactory;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundConnectionValidator;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundLdapConnectionPool;
import org.apache.jackrabbit.oak.security.authentication.ldap.impl.UnboundLookupConnectionValidator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.PrincipalNameResolver;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class LdapIdentityProvider
implements ExternalIdentityProvider,
PrincipalNameResolver {
    private static final Logger log = LoggerFactory.getLogger(LdapIdentityProvider.class);
    private static final String MARKER_CONNECT = "connect";
    private static final String MARKER_LOOKUP = "lookup";
    private LdapProviderConfig config;
    private LdapConnectionPool adminPool;
    private AbstractPoolableLdapConnectionFactory adminConnectionFactory;
    private UnboundLdapConnectionPool userPool;
    private PoolableUnboundConnectionFactory userConnectionFactory;

    public LdapIdentityProvider() {
    }

    public LdapIdentityProvider(@NotNull LdapProviderConfig config) {
        this.config = config;
        this.init();
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = LdapProviderConfig.of(cfg);
        this.init();
    }

    @Deactivate
    private void deactivate() {
        this.close();
    }

    public void close() {
        if (this.adminPool != null) {
            try {
                this.adminPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.adminPool = null;
        }
        if (this.userPool != null) {
            try {
                this.userPool.close();
            }
            catch (Exception e) {
                log.warn("Error while closing LDAP connection pool", (Throwable)e);
            }
            this.userPool = null;
        }
    }

    @NotNull
    public String fromExternalIdentityRef(@NotNull ExternalIdentityRef externalIdentityRef) throws ExternalIdentityException {
        if (!this.isMyRef(externalIdentityRef)) {
            throw new ExternalIdentityException("Foreign IDP " + externalIdentityRef.getString());
        }
        return externalIdentityRef.getId();
    }

    @NotNull
    public String getName() {
        return this.config.getName();
    }

    public ExternalIdentity getIdentity(@NotNull ExternalIdentityRef ref) throws ExternalIdentityException {
        if (!this.isMyRef(ref)) {
            return null;
        }
        LdapConnection connection = this.connect();
        try {
            ExternalUser externalUser;
            Entry entry;
            String id = ref.getId();
            boolean useUidForExtId = this.config.getUseUidForExtId();
            String userIdAttr = this.config.getUserConfig().getIdAttribute();
            String groupIdAttr = this.config.getGroupConfig().getIdAttribute();
            String[] ca = this.config.getCustomAttributes();
            if (useUidForExtId) {
                entry = this.getEntry(connection, this.config.getUserConfig(), id, this.config.getCustomAttributes());
                if (entry == null) {
                    entry = this.getEntry(connection, this.config.getGroupConfig(), id, this.config.getCustomAttributes());
                }
            } else if (ca.length == 0) {
                entry = connection.lookup(id, new String[]{"*"});
            } else {
                ArrayList<String> attributes = new ArrayList<String>(Arrays.asList(ca));
                attributes.add("objectClass");
                attributes.add(userIdAttr);
                attributes.add(groupIdAttr);
                String[] attributeArray = new String[attributes.size()];
                attributes.toArray(attributeArray);
                entry = connection.lookup(id, attributeArray);
            }
            if (entry == null) {
                externalUser = null;
                return externalUser;
            }
            if (entry.hasObjectClass(this.config.getUserConfig().getObjectClasses())) {
                externalUser = this.createUser(entry, null);
                return externalUser;
            }
            if (entry.hasObjectClass(this.config.getGroupConfig().getObjectClasses())) {
                externalUser = this.createGroup(entry, null);
                return externalUser;
            }
            log.warn("referenced identity is neither user or group: {}", (Object)ref.getString());
            externalUser = null;
            return externalUser;
        }
        catch (CursorException | LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)e, null);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalUser getUser(@NotNull String userId) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark(MARKER_CONNECT);
        try {
            Entry entry = this.getEntry(connection, this.config.getUserConfig(), userId, this.config.getCustomAttributes());
            timer.mark(MARKER_LOOKUP);
            log.debug("getUser({}) {}", (Object)userId, (Object)timer);
            if (entry != null) {
                ExternalUser externalUser = this.createUser(entry, userId);
                return externalUser;
            }
            ExternalUser externalUser = null;
            return externalUser;
        }
        catch (CursorException | LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)e, timer);
        }
        finally {
            this.disconnect(connection);
        }
    }

    public ExternalGroup getGroup(@NotNull String name) throws ExternalIdentityException {
        DebugTimer timer = new DebugTimer();
        LdapConnection connection = this.connect();
        timer.mark(MARKER_CONNECT);
        try {
            Entry entry = this.getEntry(connection, this.config.getGroupConfig(), name, this.config.getCustomAttributes());
            timer.mark(MARKER_LOOKUP);
            log.debug("getGroup({}) {}", (Object)name, (Object)timer);
            if (entry != null) {
                ExternalGroup externalGroup = this.createGroup(entry, name);
                return externalGroup;
            }
            ExternalGroup externalGroup = null;
            return externalGroup;
        }
        catch (CursorException | LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)e, timer);
        }
        finally {
            this.disconnect(connection);
        }
    }

    @NotNull
    public Iterator<ExternalUser> listUsers() throws ExternalIdentityException {
        try {
            final SearchResultIterator iter = this.getEntryIterator(this.config.getUserConfig());
            return new AbstractLazyIterator<ExternalUser>(){

                protected ExternalUser getNext() {
                    while (iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createUser((Entry)iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external user object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
        }
        catch (CursorException | LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)e, null);
        }
    }

    @NotNull
    public Iterator<ExternalGroup> listGroups() throws ExternalIdentityException {
        try {
            final SearchResultIterator iter = this.getEntryIterator(this.config.getGroupConfig());
            return new AbstractLazyIterator<ExternalGroup>(){

                protected ExternalGroup getNext() {
                    while (iter.hasNext()) {
                        try {
                            return LdapIdentityProvider.this.createGroup((Entry)iter.next(), null);
                        }
                        catch (LdapInvalidAttributeValueException e) {
                            log.warn("Error while creating external group object", (Throwable)e);
                        }
                    }
                    return null;
                }
            };
        }
        catch (CursorException | LdapException e) {
            throw LdapIdentityProvider.lookupFailedException((Exception)e, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExternalUser authenticate(@NotNull Credentials credentials) throws ExternalIdentityException, LoginException {
        if (!(credentials instanceof SimpleCredentials)) {
            log.debug("LDAP IDP can only authenticate SimpleCredentials.");
            return null;
        }
        SimpleCredentials creds = (SimpleCredentials)credentials;
        LdapUser user = (LdapUser)this.getUser(creds.getUserID());
        if (user == null) return user;
        if (creds.getPassword().length == 0) {
            throw new LoginException("Refusing to authenticate against LDAP server: Empty passwords not allowed.");
        }
        LdapConnection connection = null;
        try {
            DebugTimer timer = new DebugTimer();
            connection = this.createUserConnection();
            timer.mark(MARKER_CONNECT);
            connection.bind(user.getEntry().getDn(), new String(creds.getPassword()));
            timer.mark("bind");
            log.debug("authenticate({}) {}", (Object)user.getId(), (Object)timer);
            this.disconnectUserConnection(connection);
            return user;
        }
        catch (LdapAuthenticationException e) {
            try {
                throw new LoginException("Unable to authenticate against LDAP server: " + e.getMessage());
                catch (Exception e2) {
                    throw LdapIdentityProvider.error(e2, "Error while binding user credentials");
                }
            }
            catch (Throwable throwable) {
                this.disconnectUserConnection(connection);
                throw throwable;
            }
        }
    }

    @NotNull
    private LdapConnection createUserConnection() throws Exception {
        if (this.userPool == null) {
            return this.userConnectionFactory.create();
        }
        return this.userPool.getConnection();
    }

    private void disconnectUserConnection(@Nullable LdapConnection connection) {
        if (connection != null) {
            try {
                if (this.userPool == null) {
                    this.userConnectionFactory.destroyObject(connection);
                } else {
                    this.userPool.releaseConnection(connection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Map<String, ExternalIdentityRef> getDeclaredGroupRefs(ExternalIdentityRef ref, String dn) throws ExternalIdentityException {
        HashMap<String, ExternalIdentityRef> hashMap;
        if (!this.isMyRef(ref)) {
            return Collections.emptyMap();
        }
        String searchFilter = this.config.getMemberOfSearchFilter(dn);
        LdapConnection connection = null;
        SearchCursor searchCursor = null;
        try {
            SearchRequestImpl req = new SearchRequestImpl();
            req.setScope(SearchScope.SUBTREE);
            String idAttribute = this.config.getGroupConfig().getIdAttribute();
            req.addAttributes(new String[]{idAttribute == null ? "1.1" : idAttribute});
            req.setTimeLimit((int)this.config.getSearchTimeout());
            req.setBase(new Dn(new String[]{this.config.getGroupConfig().getBaseDN()}));
            req.setFilter(searchFilter);
            log.debug("getDeclaredGroupRefs: using SearchRequest {}.", (Object)req);
            HashMap<String, ExternalIdentityRef> groups = new HashMap<String, ExternalIdentityRef>();
            DebugTimer timer = new DebugTimer();
            connection = this.connect();
            timer.mark(MARKER_CONNECT);
            searchCursor = connection.search((SearchRequest)req);
            timer.mark("search");
            while (searchCursor.next()) {
                Response response = (Response)searchCursor.get();
                if (!(response instanceof SearchResultEntry)) continue;
                Entry resultEntry = ((SearchResultEntry)response).getEntry();
                ExternalIdentityRef groupRef = new ExternalIdentityRef(resultEntry.getDn().toString(), this.getName());
                groups.put(groupRef.getId(), groupRef);
            }
            timer.mark("iterate");
            log.debug("getDeclaredGroupRefs: search below {} with {} found {} entries. {}", new Object[]{this.config.getGroupConfig().getBaseDN(), searchFilter, groups.size(), timer});
            hashMap = groups;
        }
        catch (Exception e) {
            try {
                throw LdapIdentityProvider.error(e, "Error during ldap membership search.");
            }
            catch (Throwable throwable) {
                LdapIdentityProvider.closeSearchCursor(searchCursor);
                this.disconnect(connection);
                throw throwable;
            }
        }
        LdapIdentityProvider.closeSearchCursor(searchCursor);
        this.disconnect(connection);
        return hashMap;
    }

    Map<String, ExternalIdentityRef> getDeclaredMemberRefs(ExternalIdentityRef ref, String dn) throws ExternalIdentityException {
        if (!this.isMyRef(ref)) {
            return Collections.emptyMap();
        }
        LdapConnection connection = null;
        try {
            HashMap<String, ExternalIdentityRef> members = new HashMap<String, ExternalIdentityRef>();
            DebugTimer timer = new DebugTimer();
            connection = this.connect();
            timer.mark(MARKER_CONNECT);
            Entry entry = connection.lookup(dn);
            timer.mark(MARKER_LOOKUP);
            Attribute attr = entry.get(this.config.getGroupMemberAttribute());
            if (attr == null) {
                log.warn("LDAP group does not have configured attribute: {}", (Object)this.config.getGroupMemberAttribute());
            } else {
                for (Value value : attr) {
                    ExternalIdentityRef memberRef = new ExternalIdentityRef(value.getString(), this.getName());
                    members.put(memberRef.getId(), memberRef);
                }
            }
            timer.mark("iterate");
            log.debug("members lookup of {} found {} members. {}", new Object[]{ref.getId(), members.size(), timer});
            HashMap<String, ExternalIdentityRef> hashMap = members;
            this.disconnect(connection);
            return hashMap;
        }
        catch (Exception e) {
            try {
                throw LdapIdentityProvider.error(e, "Error during ldap group members lookup.");
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void init() {
        if (this.adminConnectionFactory != null) {
            throw new IllegalStateException("Provider already initialized.");
        }
        LdapConnectionConfig cc = this.createConnectionConfig();
        String bindDN = this.config.getBindDN();
        if (bindDN != null && !bindDN.isEmpty()) {
            cc.setName(bindDN);
            cc.setCredentials(this.config.getBindPassword());
        }
        this.adminConnectionFactory = new ValidatingPoolableLdapConnectionFactory(cc);
        if (this.config.getAdminPoolConfig().lookupOnValidate()) {
            this.adminConnectionFactory.setValidator((LdapConnectionValidator)new LookupLdapConnectionValidator());
        } else {
            this.adminConnectionFactory.setValidator((LdapConnectionValidator)new DefaultLdapConnectionValidator());
        }
        if (this.config.getAdminPoolConfig().getMaxActive() != 0) {
            this.adminPool = new LdapConnectionPool((PooledObjectFactory)this.adminConnectionFactory);
            this.adminPool.setTestOnBorrow(true);
            this.adminPool.setMaxTotal(this.config.getAdminPoolConfig().getMaxActive());
            this.adminPool.setBlockWhenExhausted(true);
            this.adminPool.setMinEvictableIdleTimeMillis(this.config.getAdminPoolConfig().getMinEvictableIdleTimeMillis());
            this.adminPool.setTimeBetweenEvictionRunsMillis(this.config.getAdminPoolConfig().getTimeBetweenEvictionRunsMillis());
            this.adminPool.setNumTestsPerEvictionRun(this.config.getAdminPoolConfig().getNumTestsPerEvictionRun());
        }
        cc = this.createConnectionConfig();
        this.userConnectionFactory = new PoolableUnboundConnectionFactory(cc);
        if (this.config.getUserPoolConfig().lookupOnValidate()) {
            this.userConnectionFactory.setValidator(new UnboundLookupConnectionValidator());
        } else {
            this.userConnectionFactory.setValidator(new UnboundConnectionValidator());
        }
        if (this.config.getUserPoolConfig().getMaxActive() != 0) {
            this.userPool = new UnboundLdapConnectionPool(this.userConnectionFactory);
            this.userPool.setTestOnBorrow(true);
            this.userPool.setMaxTotal(this.config.getUserPoolConfig().getMaxActive());
            this.userPool.setBlockWhenExhausted(true);
            this.userPool.setMinEvictableIdleTimeMillis(this.config.getUserPoolConfig().getMinEvictableIdleTimeMillis());
            this.userPool.setTimeBetweenEvictionRunsMillis(this.config.getUserPoolConfig().getTimeBetweenEvictionRunsMillis());
            this.userPool.setNumTestsPerEvictionRun(this.config.getUserPoolConfig().getNumTestsPerEvictionRun());
        }
        log.info("LdapIdentityProvider initialized: {}", (Object)this.config);
    }

    @NotNull
    private LdapConnectionConfig createConnectionConfig() {
        String[] enabledProtocols;
        LdapConnectionConfig cc = new LdapConnectionConfig();
        cc.setLdapHost(this.config.getHostname());
        cc.setLdapPort(this.config.getPort());
        cc.setUseSsl(this.config.useSSL());
        cc.setUseTls(this.config.useTLS());
        if (this.config.noCertCheck()) {
            cc.setTrustManagers(new TrustManager[]{new NoVerificationTrustManager()});
        }
        if ((enabledProtocols = this.config.enabledProtocols()) != null && enabledProtocols.length > 0) {
            cc.setEnabledProtocols(enabledProtocols);
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Entry getEntry(@NotNull LdapConnection connection, @NotNull LdapProviderConfig.Identity idConfig, @NotNull String id, @NotNull String[] customAttributes) throws CursorException, LdapException {
        String searchFilter = idConfig.getSearchFilter(id);
        SearchRequest req = LdapIdentityProvider.createSearchRequest(customAttributes, (int)this.config.getSearchTimeout(), idConfig.getBaseDN(), searchFilter);
        log.debug("getEntry: using SearchRequest {}.", (Object)req);
        SearchCursor searchCursor = null;
        Entry resultEntry = null;
        try {
            searchCursor = connection.search(req);
            while (searchCursor.next()) {
                if (resultEntry != null) {
                    log.warn("search for {} returned more than one entry. discarding additional ones.", (Object)searchFilter);
                    continue;
                }
                Response response = (Response)searchCursor.get();
                if (!(response instanceof SearchResultEntry)) continue;
                resultEntry = ((SearchResultEntry)response).getEntry();
            }
        }
        finally {
            LdapIdentityProvider.closeSearchCursor(searchCursor);
        }
        if (resultEntry == null) {
            log.debug("getEntry: search below {} with {} found 0 entries.", (Object)idConfig.getBaseDN(), (Object)searchFilter);
        } else {
            log.debug("getEntry: search below {} with {} found {}", new Object[]{idConfig.getBaseDN(), searchFilter, resultEntry.getDn()});
        }
        return resultEntry;
    }

    @NotNull
    private SearchResultIterator getEntryIterator(@NotNull LdapProviderConfig.Identity idConfig) throws LdapException, CursorException, ExternalIdentityException {
        StringBuilder filter = new StringBuilder();
        int num = 0;
        for (String objectClass : idConfig.getObjectClasses()) {
            ++num;
            filter.append("(objectclass=").append(LdapProviderConfig.encodeFilterValue(objectClass)).append(')');
        }
        String extraFilter = idConfig.getExtraFilter();
        if (extraFilter != null && !extraFilter.isEmpty()) {
            ++num;
            filter.append(extraFilter);
        }
        Object searchFilter = num > 1 ? "(&" + filter + ")" : filter.toString();
        return new SearchResultIterator((String)searchFilter, idConfig);
    }

    @NotNull
    private static SearchRequest createSearchRequest(@NotNull String[] attributes, long timeout, @NotNull String baseDN, @NotNull String searchFilter) throws LdapException {
        SearchRequestImpl req = new SearchRequestImpl();
        req.setScope(SearchScope.SUBTREE);
        if (attributes.length == 0) {
            req.addAttributes(new String[]{"*"});
        } else {
            req.addAttributes(attributes);
        }
        req.setTimeLimit((int)timeout);
        req.setBase(new Dn(new String[]{baseDN}));
        req.setFilter(searchFilter);
        return req;
    }

    @NotNull
    private ExternalUser createUser(@NotNull Entry entry, @Nullable String id) throws LdapInvalidAttributeValueException {
        return (ExternalUser)this.createIdentity(entry, id, false);
    }

    @NotNull
    private ExternalGroup createGroup(@NotNull Entry entry, @Nullable String id) throws LdapInvalidAttributeValueException {
        return (ExternalGroup)this.createIdentity(entry, id, true);
    }

    @NotNull
    private ExternalIdentity createIdentity(@NotNull Entry entry, @Nullable String id, boolean isGroup) throws LdapInvalidAttributeValueException {
        LdapProviderConfig.Identity cfg;
        LdapProviderConfig.Identity identity = cfg = isGroup ? this.config.getGroupConfig() : this.config.getUserConfig();
        if (id == null) {
            String idAttribute = cfg.getIdAttribute();
            Attribute attr = entry.get(idAttribute);
            if (attr == null) {
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, "no value found for attribute '" + idAttribute + "' for entry " + entry);
            }
            id = attr.getString();
        }
        String extId = this.config.getUseUidForExtId() ? id : entry.getDn().getName();
        ExternalIdentityRef ref = new ExternalIdentityRef(extId, this.getName());
        String path = cfg.makeDnPath() ? LdapIdentityProvider.createDNPath(entry.getDn()) : null;
        LdapIdentity identity2 = isGroup ? new LdapGroup(this, ref, id, path, entry) : new LdapUser(this, ref, id, path, entry);
        Map<String, Object> props = identity2.getProperties();
        LdapIdentityProvider.applyAttributes(props, entry);
        return identity2;
    }

    private static void applyAttributes(Map<String, Object> props, Entry entry) throws LdapInvalidAttributeValueException {
        for (Attribute attr : entry.getAttributes()) {
            Object propValue;
            if (!attr.isHumanReadable()) continue;
            if (attr.size() > 1) {
                ArrayList<String> values = new ArrayList<String>();
                for (Value value : attr) {
                    values.add(value.getString());
                }
                propValue = values;
            } else {
                propValue = attr.getString();
            }
            props.put(attr.getId(), propValue);
        }
    }

    @NotNull
    private LdapConnection connect() throws ExternalIdentityException {
        try {
            if (this.adminPool == null) {
                return (LdapConnection)this.adminConnectionFactory.makeObject().getObject();
            }
            return this.adminPool.getConnection();
        }
        catch (Exception e) {
            throw LdapIdentityProvider.error(e, "Error while connecting to the ldap server.");
        }
    }

    private void disconnect(@Nullable LdapConnection connection) {
        try {
            if (connection != null) {
                if (this.adminPool == null) {
                    this.adminConnectionFactory.destroyObject((PooledObject)new DefaultPooledObject((Object)connection));
                } else {
                    this.adminPool.releaseConnection(connection);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error while disconnecting from the ldap server.", (Throwable)e);
        }
    }

    private boolean isMyRef(@NotNull ExternalIdentityRef ref) {
        String refProviderName = ref.getProviderName();
        return refProviderName == null || refProviderName.isEmpty() || this.getName().equals(refProviderName);
    }

    private static String createDNPath(Dn dn) {
        StringBuilder path = new StringBuilder();
        for (Rdn rnd : dn.getRdns()) {
            if (path.length() > 0) {
                path.append('/');
            }
            path.append(Text.escapeIllegalJcrChars((String)rnd.toString()));
        }
        return path.toString();
    }

    private static ExternalIdentityException lookupFailedException(@NotNull Exception e, @Nullable DebugTimer timer) {
        String msg = "Error during ldap lookup. {}";
        log.error(msg, (Object)(timer != null ? timer.getString() : ""), (Object)e);
        return new ExternalIdentityException(msg, (Throwable)e);
    }

    private static ExternalIdentityException error(@NotNull Exception e, @NotNull String msg) {
        log.error(msg, (Throwable)e);
        return new ExternalIdentityException(msg, (Throwable)e);
    }

    private static void closeSearchCursor(@Nullable SearchCursor searchCursor) {
        if (searchCursor != null) {
            try {
                searchCursor.close();
            }
            catch (IOException e) {
                log.warn("Failed to close search cursor.", (Throwable)e);
            }
        }
    }

    private final class SearchResultIterator
    implements Iterator<Entry> {
        private final String searchFilter;
        private final LdapProviderConfig.Identity idConfig;
        private byte[] cookie;
        private List<Entry> page = Collections.emptyList();
        private boolean searchComplete;
        private int pos = -1;

        public SearchResultIterator(@NotNull String searchFilter, LdapProviderConfig.Identity idConfig) throws LdapException, CursorException, ExternalIdentityException {
            this.searchFilter = searchFilter;
            this.idConfig = idConfig;
            this.findNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public Entry next() {
            if (this.hasNext()) {
                try {
                    Entry entry = this.page.get(this.pos);
                    this.findNextEntry();
                    return entry;
                }
                catch (CursorException | LdapException | ExternalIdentityException e) {
                    log.error("Error while performing LDAP search", e);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        private SearchRequest createSearchRequest(byte[] cookie, @NotNull String[] userAttributes) throws LdapException {
            SearchRequest req = LdapIdentityProvider.createSearchRequest(userAttributes, LdapIdentityProvider.this.config.getSearchTimeout(), this.idConfig.getBaseDN(), this.searchFilter);
            PagedResultsImpl pagedResults = new PagedResultsImpl();
            pagedResults.setSize(1000);
            pagedResults.setCookie(cookie);
            req.addControl((Control)pagedResults);
            return req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadNextPage() throws ExternalIdentityException, LdapException, CursorException {
            boolean bl;
            if (this.searchComplete) {
                return false;
            }
            SearchCursor searchCursor = null;
            DebugTimer timer = new DebugTimer();
            LdapConnection connection = LdapIdentityProvider.this.connect();
            timer.mark(LdapIdentityProvider.MARKER_CONNECT);
            this.page = new ArrayList<Entry>();
            try {
                PagedResults ctrl;
                SearchResultDone searchResultDone;
                SearchRequest req = this.createSearchRequest(this.cookie, LdapIdentityProvider.this.config.getCustomAttributes());
                log.debug("loadNextPage: using SearchRequest {}.", (Object)req);
                searchCursor = connection.search(req);
                while (searchCursor.next()) {
                    Response response = (Response)searchCursor.get();
                    if (!(response instanceof SearchResultEntry)) continue;
                    Entry resultEntry = ((SearchResultEntry)response).getEntry();
                    this.page.add(resultEntry);
                    log.debug("loadNextPage: search below {} with {} found {}", new Object[]{this.idConfig.getBaseDN(), this.searchFilter, resultEntry.getDn()});
                }
                boolean done = searchCursor.isDone();
                this.cookie = null;
                if (done && (searchResultDone = searchCursor.getSearchResultDone()) != null && searchResultDone.getLdapResult().getResultCode() != ResultCodeEnum.UNWILLING_TO_PERFORM && (ctrl = (PagedResults)searchResultDone.getControl("1.2.840.113556.1.4.319")) != null) {
                    this.cookie = ctrl.getCookie();
                }
                this.searchComplete = this.cookie == null || this.cookie.length == 0;
                timer.mark(LdapIdentityProvider.MARKER_LOOKUP);
                bl = !this.page.isEmpty();
            }
            catch (Throwable throwable) {
                LdapIdentityProvider.closeSearchCursor(searchCursor);
                LdapIdentityProvider.this.disconnect(connection);
                throw throwable;
            }
            LdapIdentityProvider.closeSearchCursor(searchCursor);
            LdapIdentityProvider.this.disconnect(connection);
            return bl;
        }

        private void findNextEntry() throws LdapException, CursorException, ExternalIdentityException {
            if (this.pos == -1 && !this.loadNextPage()) {
                return;
            }
            if (this.pos + 1 == this.page.size()) {
                this.pos = -1;
                this.page = Collections.emptyList();
                if (!this.loadNextPage()) {
                    return;
                }
            }
            ++this.pos;
        }
    }
}

