/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={MountedNodeStoreChecker.class})
public class NodeTypeMountedNodeStoreChecker
implements MountedNodeStoreChecker<Context> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(label="The name of a node type that is invalid and will be rejected when found")
    private static final String INVALID_NODE_TYPE = "invalidNodeType";
    @Property(label="The error label to use when rejecting an invalid node type")
    private static final String ERROR_LABEL = "errorLabel";
    @Property(label="Node types that will cause the check to succeeed, even in the invalid node type is also found.", cardinality=0x7FFFFFFF)
    private static final String EXCLUDED_NODE_TYPES = "excludedNodeTypes";
    private String invalidNodeType;
    private String errorLabel;
    private Set<String> excludedNodeTypes;

    public NodeTypeMountedNodeStoreChecker() {
    }

    public NodeTypeMountedNodeStoreChecker(String invalidNodeType, String errorLabel, String ... excludedNodeTypes) {
        this.invalidNodeType = invalidNodeType;
        this.errorLabel = errorLabel;
        this.excludedNodeTypes = ImmutableSet.copyOf((Object[])excludedNodeTypes);
    }

    protected void activate(ComponentContext ctx) {
        this.invalidNodeType = (String)Preconditions.checkNotNull((Object)PropertiesUtil.toString(ctx.getProperties().get(INVALID_NODE_TYPE), null), (Object)INVALID_NODE_TYPE);
        this.errorLabel = (String)Preconditions.checkNotNull((Object)PropertiesUtil.toString(ctx.getProperties().get(ERROR_LABEL), null), (Object)ERROR_LABEL);
        this.excludedNodeTypes = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray(ctx.getProperties().get(EXCLUDED_NODE_TYPES), (String[])new String[0]));
    }

    @Override
    public Context createContext(NodeStore globalStore, MountInfoProvider mip) {
        Root globalRoot = RootFactory.createReadOnlyRoot((NodeState)globalStore.getRoot());
        ReadOnlyNodeTypeManager typeManager = ReadOnlyNodeTypeManager.getInstance((Root)globalRoot, (NamePathMapper)NamePathMapper.DEFAULT);
        return new Context(typeManager);
    }

    @Override
    public boolean check(MountedNodeStore mountedStore, Tree tree, ErrorHolder errorHolder, Context context) {
        if (context.getTypeManager().isNodeType(tree, this.invalidNodeType) && !this.isExcluded(mountedStore, tree, context)) {
            errorHolder.report(mountedStore, tree.getPath(), this.errorLabel, this);
        }
        return true;
    }

    private boolean isExcluded(MountedNodeStore mountedStore, Tree tree, Context context) {
        for (String excludedNodeType : this.excludedNodeTypes) {
            if (!context.getTypeManager().isNodeType(tree, excludedNodeType)) continue;
            this.log.warn("Not failing check for tree at path {}, mount {} due to matching excluded node type {}", new Object[]{tree.getPath(), mountedStore.getMount().getName(), excludedNodeType});
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + ": [ invalidNodeType: " + this.invalidNodeType + ", excludedNodeTypes: " + this.excludedNodeTypes + " ]";
    }

    protected static class Context {
        private final ReadOnlyNodeTypeManager typeManager;

        Context(ReadOnlyNodeTypeManager typeManager) {
            this.typeManager = typeManager;
        }

        public ReadOnlyNodeTypeManager getTypeManager() {
            return this.typeManager;
        }
    }
}

