/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.plugins.name.ReadOnlyNamespaceRegistry;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

@Component
@Service(value={MountedNodeStoreChecker.class})
public class NamespacePrefixNodestoreChecker
implements MountedNodeStoreChecker<Context> {
    @Override
    public Context createContext(NodeStore globalStore, MountInfoProvider mip) {
        Root root = RootFactory.createReadOnlyRoot((NodeState)globalStore.getRoot());
        ReadOnlyNamespaceRegistry registry = new ReadOnlyNamespaceRegistry(root);
        return new Context(registry.getPrefixes());
    }

    @Override
    public boolean check(MountedNodeStore mountedStore, Tree tree, ErrorHolder errorHolder, Context context) {
        String name = tree.getName();
        String path = tree.getPath();
        this.validate(mountedStore, errorHolder, context, name, path);
        for (PropertyState prop : tree.getProperties()) {
            String propName = prop.getName();
            this.validate(mountedStore, errorHolder, context, propName, PathUtils.concat((String)tree.getPath(), (String)propName));
        }
        return true;
    }

    private void validate(MountedNodeStore mountedStore, ErrorHolder errorHolder, Context context, String name, String path) {
        String prefix = NamespacePrefixNodestoreChecker.getPrefix(name);
        if (prefix != null && !context.validPrefixes.contains(prefix)) {
            errorHolder.report(mountedStore, path, "invalid namespace prefix " + prefix + " , expected one of " + context.validPrefixes, this);
        }
    }

    private static String getPrefix(String name) {
        int idx = name.indexOf(58);
        if (idx < 0) {
            return null;
        }
        return name.substring(0, idx);
    }

    static class Context {
        private final Set<String> validPrefixes = Sets.newHashSet();

        public Context(String[] prefixes) {
            for (String prefix : prefixes) {
                this.validPrefixes.add(prefix);
            }
        }
    }
}

