/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.oak.composite.MountInfoConfig;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Props.class)
public class MountInfoProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(MountInfoProviderService.class);
    private final List<MountInfoConfig> mountInfoConfigs = new ArrayList<MountInfoConfig>();
    private Set<String> expectedMounts;
    private ServiceRegistration reg;
    private BundleContext context;

    @Activate
    public void activate(BundleContext bundleContext, Props props) {
        String[] expectedMounts = props.expectedMounts();
        this.expectedMounts = expectedMounts != null ? Stream.of(expectedMounts).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()) : new HashSet<String>();
        this.context = bundleContext;
        this.addMountInfoConfigFromProperties(props);
        this.registerMountInfoProvider();
    }

    @Deprecated
    private void addMountInfoConfigFromProperties(Props mountInfoProps) {
        String[] paths = mountInfoProps.mountedPaths();
        String mountName = mountInfoProps.mountName();
        boolean readOnly = mountInfoProps.readOnlyMount();
        String[] pathsSupportingFragments = mountInfoProps.pathsSupportingFragments();
        if (paths != null && paths.length > 0) {
            this.mountInfoConfigs.add(new MountInfoConfig(mountName, Arrays.asList(paths), Arrays.asList(pathsSupportingFragments), readOnly));
            this.expectedMounts.add(mountName);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindMountInfoConfig(MountInfoConfig config) {
        if (!config.getPaths().isEmpty()) {
            this.mountInfoConfigs.add(config);
        }
    }

    private void registerMountInfoProvider() {
        MountInfoProvider mip;
        if (this.context == null || this.reg != null) {
            return;
        }
        Set providedMounts = this.mountInfoConfigs.stream().map(MountInfoConfig::getMountName).collect(Collectors.toSet());
        if (!providedMounts.containsAll(this.expectedMounts)) {
            LOG.info("Not all expected mounts are present yet (expected: {}, current: {}). Postponing configuration...", this.expectedMounts, providedMounts);
            return;
        }
        boolean hasPaths = this.mountInfoConfigs.stream().anyMatch(conf -> !conf.getPaths().isEmpty());
        if (hasPaths) {
            Mounts.Builder builder = Mounts.newBuilder();
            for (MountInfoConfig mountInfoConfig : this.mountInfoConfigs) {
                if (mountInfoConfig.getPaths().isEmpty()) continue;
                builder.mount(mountInfoConfig.getMountName(), mountInfoConfig.isReadOnly(), mountInfoConfig.getPathsSupportingFragments(), mountInfoConfig.getPaths());
                LOG.info("Enabling mount for {} with paths: {}", (Object)mountInfoConfig.getMountName(), mountInfoConfig.getPaths());
            }
            mip = builder.build();
        } else {
            mip = Mounts.defaultMountInfoProvider();
            LOG.info("No mount config provided. Mounting would be disabled");
        }
        this.reg = this.context.registerService(MountInfoProvider.class.getName(), (Object)mip, null);
    }

    @Deactivate
    private void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    @ObjectClassDefinition(name="MountInfoProviderService Properties")
    static @interface Props {
        public static final String DEFAULT_MOUNT_NAME = "private";

        @AttributeDefinition(name="Expected mounts", description="List of all required mount names")
        public String[] expectedMounts() default {};

        @Deprecated
        @AttributeDefinition(name="Mounted paths", description="Paths which are part of private mount")
        public String[] mountedPaths() default {};

        @Deprecated
        @AttributeDefinition(name="Mount name", description="Name of the mount")
        public String mountName() default "private";

        @Deprecated
        @AttributeDefinition(name="Readonly", description="If enabled then mount would be considered as readonly")
        public boolean readOnlyMount() default true;

        @Deprecated
        @AttributeDefinition(name="Paths supporting fragments", description="oak:mount-* under this paths will be included to mounts")
        public String[] pathsSupportingFragments() default {"/"};
    }
}

