/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.model.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureModelTask
extends InstallTask {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BundleContext bundleContext;
    private final Map<ServiceReference<?>, Object> services = new HashMap();

    public AbstractFeatureModelTask(TaskResourceGroup group, BundleContext bundleContext) {
        super(group);
        this.bundleContext = bundleContext;
    }

    protected void cleanup() {
        for (ServiceReference<?> r : this.services.keySet()) {
            this.bundleContext.ungetService(r);
        }
        this.services.clear();
    }

    protected String getScheme(TaskResource resource) {
        return "model-".concat(resource.getAttribute("featureId").toString().replace(':', '_'));
    }

    protected <T> T getService(Class<T> type) {
        Object service = null;
        ServiceReference reference = this.bundleContext.getServiceReference(type);
        if (reference != null && (service = this.services.get(reference)) == null && (service = this.bundleContext.getService(reference)) != null) {
            this.services.put(reference, service);
        }
        if (service == null) {
            this.logger.error("Unable to get OSGi service " + type.getName());
        }
        return (T)service;
    }

    protected void deleteDirectory(File dir) {
        if (dir.exists()) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
            dir.delete();
        }
    }
}

