/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.permission;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public interface TreePermission {
    public static final TreePermission EMPTY = new TreePermission(){

        @Override
        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            return EMPTY;
        }

        @Override
        public boolean canRead() {
            return false;
        }

        @Override
        public boolean canRead(@NotNull PropertyState property) {
            return false;
        }

        @Override
        public boolean canReadAll() {
            return false;
        }

        @Override
        public boolean canReadProperties() {
            return false;
        }

        @Override
        public boolean isGranted(long permissions) {
            return false;
        }

        @Override
        public boolean isGranted(long permissions, @NotNull PropertyState property) {
            return false;
        }

        public String toString() {
            return "TreePermission.EMPTY";
        }
    };
    public static final TreePermission ALL = new TreePermission(){

        @Override
        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            return ALL;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canRead(@NotNull PropertyState property) {
            return true;
        }

        @Override
        public boolean canReadAll() {
            return true;
        }

        @Override
        public boolean canReadProperties() {
            return true;
        }

        @Override
        public boolean isGranted(long permissions) {
            return true;
        }

        @Override
        public boolean isGranted(long permissions, @NotNull PropertyState property) {
            return true;
        }

        public String toString() {
            return "TreePermission.ALL";
        }
    };
    public static final TreePermission NO_RECOURSE = new TreePermission(){

        @Override
        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canRead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canRead(@NotNull PropertyState property) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canReadAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canReadProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGranted(long permissions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGranted(long permissions, @NotNull PropertyState property) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "TreePermission.NO_RECOURSE";
        }
    };

    @NotNull
    public TreePermission getChildPermission(@NotNull String var1, @NotNull NodeState var2);

    public boolean canRead();

    public boolean canRead(@NotNull PropertyState var1);

    public boolean canReadAll();

    public boolean canReadProperties();

    public boolean isGranted(long var1);

    public boolean isGranted(long var1, @NotNull PropertyState var3);
}

