/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.security.Principal;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.core.internal.CommonUtils;
import org.apache.sling.cms.core.internal.SimplePrincipal;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=createuser"})
public class CreateUserOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(CreateUserOperation.class);
    public static final String PN_PASSWORD = ":password";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList changes = new ArrayList();
        try {
            String name = request.getParameter(":name");
            String password = request.getParameter(PN_PASSWORD);
            ResourceResolver resolver = request.getResourceResolver();
            UserManager userManager = CommonUtils.getUserManager(resolver);
            if (userManager.getAuthorizable((Principal)new SimplePrincipal(name)) != null) {
                throw new RepositoryException("Authorizable with id " + name + " already exists");
            }
            String intermediatePath = StringUtils.substringBeforeLast((String)request.getResource().getPath(), (String)"/").replaceAll("\\/home\\/users\\/?", "");
            User user = userManager.createUser(name, password, (Principal)new SimplePrincipal(name), intermediatePath);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.setPath(user.getPath());
            response.onCreated(user.getPath());
        }
        catch (Exception e) {
            log.warn("Failed to create user", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

