/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightProvider;
import org.apache.sling.cms.insights.InsightRequest;
import org.apache.sling.cms.insights.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInsightProvider
implements InsightProvider {
    private static final Logger log = LoggerFactory.getLogger(BaseInsightProvider.class);

    protected abstract Insight doEvaluateRequest(InsightRequest var1) throws Exception;

    public Insight evaluateRequest(InsightRequest request) {
        log.trace("evaluatePage");
        Insight insight = null;
        try {
            insight = this.doEvaluateRequest(request);
        }
        catch (Exception e) {
            log.error("Unable to perform check " + this.getTitle() + " for request " + request, (Throwable)e);
            insight = new Insight((InsightProvider)this, request);
            insight.getScoreDetails().add(new Message("Unable to perform check " + this.getTitle() + " due to unexpected exception", Message.STYLE.DANGER));
            insight.setSucceeded(false);
            insight.setScored(false);
        }
        return insight;
    }
}

