/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.selector;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.spi.AbstractAuthenticationFormServlet;
import org.apache.sling.auth.form.FormReason;
import org.apache.sling.auth.openid.OpenIDFailure;

@Component
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Default Login Form for the Authenticator Selector"})})
@Service(value={Servlet.class})
public class SelectorFormServlet
extends AbstractAuthenticationFormServlet {
    @Property(name="sling.servlet.paths")
    static final String SERVLET_PATH = "/system/sling/selector/login";
    @Property(name="sling.auth.requirements")
    private static final String[] AUTH_REQUIREMENT = new String[]{"-/system/sling/selector/login", "-/sling.css", "-/sling-logo.png", "-/signup.html"};

    protected String getForm(HttpServletRequest request) throws IOException {
        String form = super.getForm(request);
        form = form.replace("${selectedAuthType}", this.getSelectedAuthType(request));
        return form;
    }

    private String getSelectedAuthType(HttpServletRequest request) {
        String type = request.getParameter("selectedAuthType");
        if (type == null || type.length() == 0) {
            return "null";
        }
        type = StringEscapeUtils.escapeJavaScript((String)type);
        return "\"" + type + "\"";
    }

    protected String getReason(HttpServletRequest request) {
        Object formResObj = request.getAttribute("j_reason");
        if (formResObj instanceof Enum) {
            return formResObj.toString();
        }
        String jReason = request.getParameter("j_reason");
        if (jReason != null) {
            try {
                return FormReason.valueOf((String)jReason).toString();
            }
            catch (IllegalArgumentException iae) {
                try {
                    String idObject;
                    OpenIDFailure failure = OpenIDFailure.valueOf((String)jReason);
                    if (failure == OpenIDFailure.REPOSITORY && (idObject = request.getParameter("j_openid_identity")) instanceof String) {
                        return "Cannot associate Repository User with OpenID identifier " + idObject;
                    }
                    return failure.toString();
                }
                catch (IllegalArgumentException iae2) {
                    return jReason;
                }
            }
        }
        return "";
    }
}

