/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.micronaut.http.client;

import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import java.net.URI;
import java.util.function.Consumer;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.micronaut.http.client.MicronautHttpClientPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class MicronautCommons {
    private static final String SPAN_KEY = "CORS_SPAN";
    private static final String SKY_CONTEXT_SNAPSHOT_KEY = "CORS_SNAPSHOT";

    static void beginTrace(MutableHttpRequest<?> request, URI requestURI) {
        String requestMethod = request.getMethod().name();
        AbstractSpan span = ContextManager.createExitSpan((String)(requestMethod + ":" + request.getPath()), (String)(requestURI.getHost() + ":" + requestURI.getPort()));
        ServerRequestContext.currentRequest().flatMap(req -> req.getAttribute((CharSequence)SKY_CONTEXT_SNAPSHOT_KEY)).ifPresent(e -> ContextManager.continued((ContextSnapshot)((ContextSnapshot)e)));
        ContextCarrier contextCarrier = new ContextCarrier();
        ContextManager.inject((ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.MICRONAUT);
        Tags.HTTP.METHOD.set(span, requestMethod);
        Tags.URL.set(span, String.format("%s://%s:%s%s", requestURI.getScheme(), requestURI.getHost(), requestURI.getPort(), requestURI.getPath()));
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            request.header((CharSequence)next.getHeadKey(), (CharSequence)next.getHeadValue());
        }
        span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)span);
        request.setAttribute((CharSequence)SPAN_KEY, (Object)span);
        if (MicronautHttpClientPluginConfig.Plugin.MicronautHttpClient.COLLECT_HTTP_PARAMS) {
            MicronautCommons.collectHttpParam(request, span);
        }
    }

    static Publisher<? extends HttpResponse<?>> buildTracePublisher(MutableHttpRequest<?> request, Publisher<? extends HttpResponse<?>> retPublisher) {
        return Flux.from(retPublisher).doOnError(ex -> MicronautCommons.finish(request, span -> span.log(ex).errorOccurred())).doOnNext(resp -> MicronautCommons.finish(request, span -> {
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(resp.code()));
            if (resp.code() >= 400) {
                span.errorOccurred();
            }
            if (!MicronautHttpClientPluginConfig.Plugin.MicronautHttpClient.COLLECT_HTTP_PARAMS && span.isProfiling()) {
                MicronautCommons.collectHttpParam(request, span);
            }
        }));
    }

    static void collectHttpParam(MutableHttpRequest<?> httpRequest, AbstractSpan span) {
        String tag = httpRequest.getUri().getQuery();
        String string = tag = MicronautHttpClientPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tag, (int)MicronautHttpClientPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tag;
        if (StringUtil.isNotEmpty((String)tag)) {
            Tags.HTTP.PARAMS.set(span, tag);
        }
    }

    static void finish(MutableHttpRequest<?> request, Consumer<AbstractSpan> action) {
        try {
            request.getAttribute((CharSequence)SPAN_KEY).map(span -> (AbstractSpan)span).ifPresent(span -> {
                action.accept((AbstractSpan)span);
                span.asyncFinish();
            });
        }
        finally {
            request.removeAttribute((CharSequence)SPAN_KEY, AbstractSpan.class);
        }
    }
}

