/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.CorrelationContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionContext;
import org.apache.skywalking.apm.agent.core.context.IgnoreTracerContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopSpan;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusContext;
import org.apache.skywalking.apm.agent.core.so11y.AgentSo11y;

public class IgnoredTracerContext
implements AbstractTracerContext {
    private static final NoopSpan NOOP_SPAN = new NoopSpan();
    private static final String IGNORE_TRACE = "Ignored_Trace";
    private final CorrelationContext correlationContext;
    private final ExtensionContext extensionContext;
    private final ProfileStatusContext profileStatusContext;
    private int stackDepth;

    public IgnoredTracerContext() {
        this.stackDepth = 0;
        this.correlationContext = new CorrelationContext();
        this.extensionContext = new ExtensionContext();
        this.profileStatusContext = ProfileStatusContext.createWithNone();
    }

    public IgnoredTracerContext(int stackDepth) {
        this.stackDepth = stackDepth;
        this.correlationContext = new CorrelationContext();
        this.extensionContext = new ExtensionContext();
        this.profileStatusContext = ProfileStatusContext.createWithNone();
    }

    @Override
    public void inject(ContextCarrier carrier) {
        this.correlationContext.inject(carrier);
    }

    @Override
    public void extract(ContextCarrier carrier) {
        this.correlationContext.extract(carrier);
    }

    @Override
    public ContextSnapshot capture() {
        return new ContextSnapshot(null, -1, null, null, this.correlationContext, this.extensionContext, this.profileStatusContext);
    }

    @Override
    public void continued(ContextSnapshot snapshot) {
        this.correlationContext.continued(snapshot);
    }

    @Override
    public String getReadablePrimaryTraceId() {
        return IGNORE_TRACE;
    }

    @Override
    public String getSegmentId() {
        return IGNORE_TRACE;
    }

    @Override
    public int getSpanId() {
        return -1;
    }

    @Override
    public AbstractSpan createEntrySpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createLocalSpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createExitSpan(String operationName, String remotePeer) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan activeSpan() {
        return NOOP_SPAN;
    }

    @Override
    public boolean stopSpan(AbstractSpan span) {
        --this.stackDepth;
        if (this.stackDepth == 0) {
            AgentSo11y.measureTracingContextCompletion(true);
            ListenerManager.notifyFinish(this);
        }
        return this.stackDepth == 0;
    }

    @Override
    public AbstractTracerContext awaitFinishAsync() {
        return this;
    }

    @Override
    public void asyncStop(AsyncSpan span) {
    }

    @Override
    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    @Override
    public String getPrimaryEndpointName() {
        return null;
    }

    @Override
    public AbstractTracerContext forceIgnoring() {
        return this;
    }

    public static class ListenerManager {
        private static List<IgnoreTracerContextListener> LISTENERS = new LinkedList<IgnoreTracerContextListener>();

        public static synchronized void add(IgnoreTracerContextListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(IgnoredTracerContext ignoredTracerContext) {
            for (IgnoreTracerContextListener listener : LISTENERS) {
                listener.afterFinished(ignoredTracerContext);
            }
        }

        public static synchronized void remove(IgnoreTracerContextListener listener) {
            LISTENERS.remove(listener);
        }
    }
}

