/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.servicecomb.v2;

import java.lang.reflect.Method;
import org.apache.servicecomb.core.Invocation;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ProducerOperationHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Invocation invocation = (Invocation)allArguments[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            String headKey = next.getHeadKey();
            if (invocation.getContext().containsKey(headKey)) {
                next.setHeadValue((String)invocation.getContext().get(headKey));
                continue;
            }
            next.setHeadValue(invocation.getRequestEx().getHeader(headKey));
        }
        String operationName = invocation.getMicroserviceQualifiedName();
        AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
        String url = invocation.getOperationMeta().getOperationPath();
        Tags.URL.set(span, url);
        span.setComponent((Component)ComponentsDefine.SERVICECOMB);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Invocation invocation = (Invocation)allArguments[0];
        AbstractSpan span = ContextManager.activeSpan();
        int statusCode = invocation.getStatus().getStatusCode();
        Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
        if (statusCode >= 400) {
            span.errorOccurred();
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }
}

