/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hystrix.v1;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.plugin.hystrix.v1.EnhanceRequireObjectCache;

public class SWExecutionHookWrapper
extends HystrixCommandExecutionHook {
    private final HystrixCommandExecutionHook actual;
    private static ILog LOGGER = LogManager.getLogger(SWExecutionHookWrapper.class);

    public SWExecutionHookWrapper(HystrixCommandExecutionHook actual) {
        this.actual = actual;
    }

    public <T> void onStart(HystrixInvokable<T> commandInstance) {
        if (!(commandInstance instanceof EnhancedInstance)) {
            this.actual.onStart(commandInstance);
            return;
        }
        try {
            EnhancedInstance enhancedInstance = (EnhancedInstance)commandInstance;
            EnhanceRequireObjectCache enhanceRequireObjectCache = (EnhanceRequireObjectCache)enhancedInstance.getSkyWalkingDynamicField();
            if (ContextManager.isActive()) {
                enhanceRequireObjectCache.setContextSnapshot(ContextManager.capture());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set ContextSnapshot.", (Throwable)e);
        }
        this.actual.onStart(commandInstance);
    }

    public <T> void onExecutionStart(HystrixInvokable<T> commandInstance) {
        this.actual.onExecutionStart(commandInstance);
    }

    public <T> Exception onExecutionError(HystrixInvokable<T> commandInstance, Exception e) {
        return this.actual.onExecutionError(commandInstance, e);
    }

    public <T> void onExecutionSuccess(HystrixInvokable<T> commandInstance) {
        this.actual.onExecutionSuccess(commandInstance);
    }

    public <T> void onFallbackStart(HystrixInvokable<T> commandInstance) {
        this.actual.onFallbackStart(commandInstance);
    }

    public <T> Exception onFallbackError(HystrixInvokable<T> commandInstance, Exception e) {
        return this.actual.onFallbackError(commandInstance, e);
    }

    public <T> void onFallbackSuccess(HystrixInvokable<T> commandInstance) {
        this.actual.onFallbackSuccess(commandInstance);
    }

    public <T> Exception onRunError(HystrixInvokable<T> commandInstance, Exception e) {
        return this.actual.onRunError(commandInstance, e);
    }

    public <T> Exception onRunError(HystrixCommand<T> commandInstance, Exception e) {
        return this.actual.onRunError(commandInstance, e);
    }

    public <T> Exception onError(HystrixInvokable<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
        return this.actual.onError(commandInstance, failureType, e);
    }

    public <T> void onSuccess(HystrixInvokable<T> commandInstance) {
        this.actual.onSuccess(commandInstance);
    }

    public <T> T onEmit(HystrixInvokable<T> commandInstance, T value) {
        return (T)this.actual.onEmit(commandInstance, value);
    }

    public <T> T onExecutionEmit(HystrixInvokable<T> commandInstance, T value) {
        return (T)this.actual.onExecutionEmit(commandInstance, value);
    }

    public <T> T onFallbackEmit(HystrixInvokable<T> commandInstance, T value) {
        return (T)this.actual.onFallbackEmit(commandInstance, value);
    }

    public <T> void onCacheHit(HystrixInvokable<T> commandInstance) {
        this.actual.onCacheHit(commandInstance);
    }

    public <T> void onThreadComplete(HystrixInvokable<T> commandInstance) {
        this.actual.onThreadComplete(commandInstance);
    }

    public <T> void onThreadStart(HystrixInvokable<T> commandInstance) {
        this.actual.onThreadStart(commandInstance);
    }

    public <T> Exception onError(HystrixCommand<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
        return this.actual.onError(commandInstance, failureType, e);
    }

    public <T> Exception onFallbackError(HystrixCommand<T> commandInstance, Exception e) {
        return this.actual.onFallbackError(commandInstance, e);
    }

    public <T> T onComplete(HystrixCommand<T> commandInstance, T response) {
        return (T)this.actual.onComplete(commandInstance, response);
    }

    public <T> T onComplete(HystrixInvokable<T> commandInstance, T response) {
        return (T)this.actual.onComplete(commandInstance, response);
    }

    public <T> T onFallbackSuccess(HystrixCommand<T> commandInstance, T fallbackResponse) {
        return (T)this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
    }

    public <T> T onFallbackSuccess(HystrixInvokable<T> commandInstance, T fallbackResponse) {
        return (T)this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
    }

    public <T> T onRunSuccess(HystrixCommand<T> commandInstance, T response) {
        return (T)this.actual.onRunSuccess(commandInstance, response);
    }

    public <T> T onRunSuccess(HystrixInvokable<T> commandInstance, T response) {
        return (T)this.actual.onRunSuccess(commandInstance, response);
    }

    public <T> void onFallbackStart(HystrixCommand<T> commandInstance) {
        this.actual.onFallbackStart(commandInstance);
    }

    public <T> void onRunStart(HystrixCommand<T> commandInstance) {
        this.actual.onRunStart(commandInstance);
    }

    public <T> void onRunStart(HystrixInvokable<T> commandInstance) {
        this.actual.onRunStart(commandInstance);
    }

    public <T> void onStart(HystrixCommand<T> commandInstance) {
        if (!(commandInstance instanceof EnhancedInstance)) {
            this.actual.onStart(commandInstance);
            return;
        }
        try {
            EnhancedInstance enhancedInstance = (EnhancedInstance)commandInstance;
            EnhanceRequireObjectCache enhanceRequireObjectCache = (EnhanceRequireObjectCache)enhancedInstance.getSkyWalkingDynamicField();
            if (ContextManager.isActive()) {
                enhanceRequireObjectCache.setContextSnapshot(ContextManager.capture());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set ContextSnapshot.", (Throwable)e);
        }
        this.actual.onStart(commandInstance);
    }

    public <T> void onThreadComplete(HystrixCommand<T> commandInstance) {
        this.actual.onThreadComplete(commandInstance);
    }

    public <T> void onThreadStart(HystrixCommand<T> commandInstance) {
        this.actual.onThreadStart(commandInstance);
    }
}

