/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.samza.logging.log4j2.serializers;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.samza.config.Config;
import org.apache.samza.config.Log4jSystemConfig;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeFactory;


public class LoggingEventJsonSerdeFactory implements SerdeFactory<LogEvent> {

  @Override
  public Serde<LogEvent> getSerde(String name, Config config) {
    boolean locationInfoEnabled = new Log4jSystemConfig(config).getLocationEnabled();
    return new LoggingEventJsonSerde(locationInfoEnabled);
  }
}
