/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createElementNS raises a NAMESPACE_ERR if the qualifiedName
 * has a prefix and
 * the namespaceURI is null.
 * <p>
 * Invoke the createElementNS method on a new Document object with a null value for
 * namespaceURI, and a valid qualifiedName.  Check if a NAMESPACE_ERR is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrElNS</a>
 */
public class documentcreateelementNS05 {
    @Test
    void testRun() throws Throwable {
        String namespaceURI = null;

        String qualifiedName = "null:xml";
        Document doc = load("staffNS", false);

        DOMException ex = assertThrows(DOMException.class, () -> doc.createElementNS(namespaceURI, qualifiedName));
        assertEquals(DOMException.NAMESPACE_ERR, ex.code, "documentcreateelementNS05, null value for namespaceURI, and a valid qualifiedName");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateelementNS05";
    }

}
