/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.client;

import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.phoenix.queryserver.client.KerberosLoginFromTicketCache;
import sqlline.SqlLine;

public class SqllineWrapper {
    public static String getUrl(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg;
            args[i] = arg = args[i];
            if (!arg.equals("-u") || args.length <= i + 1) continue;
            return args[i + 1];
        }
        return null;
    }

    public static void main(final String[] args) throws Exception {
        String url = SqllineWrapper.getUrl(args);
        if (url.contains(";authentication=SPNEGO") && !url.contains(";principal=")) {
            try {
                Subject subject = KerberosLoginFromTicketCache.login();
                System.out.println("Kerberos login from ticket cache successful");
                Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SqlLine.main((String[])args);
                        return null;
                    }
                });
                return;
            }
            catch (LoginException e) {
                System.out.print("Kerberos login from ticket cache not successful");
                e.printStackTrace();
            }
        }
        SqlLine.main((String[])args);
    }
}

