/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jline.builtins.Completers;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import sqlline.BuiltInHighlightStyle;
import sqlline.BuiltInProperty;
import sqlline.Commands;
import sqlline.SqlLine;
import sqlline.SqlLineCommandCompleter;
import sqlline.SqlLineProperty;

public class SqlLineOpts
implements Completer {
    public static final String PROPERTY_PREFIX = "sqlline.";
    public static final String PROPERTY_NAME_EXIT = "sqlline.system.exit";
    private static final Date TEST_DATE = new Date();
    private static final String DEV_NULL = "/dev/null";
    private SqlLine sqlLine;
    private String runFile;
    private Pattern compiledConfirmPattern = null;
    private Set<String> propertyNames;
    private final Map<SqlLineProperty, Object> propertiesMap = new HashMap<SqlLineProperty, Object>();
    private final Map<SqlLineProperty, SqlLineProperty.Writer> propertiesConfig = Collections.unmodifiableMap(new HashMap<SqlLineProperty, SqlLineProperty.Writer>(){
        {
            this.put(BuiltInProperty.COLOR_SCHEME, SqlLineOpts.this::setColorScheme);
            this.put(BuiltInProperty.CONFIRM_PATTERN, SqlLineOpts.this::setConfirmPattern);
            this.put(BuiltInProperty.CSV_QUOTE_CHARACTER, SqlLineOpts.this::setCsvQuoteCharacter);
            this.put(BuiltInProperty.DATE_FORMAT, SqlLineOpts.this::setDateFormat);
            this.put(BuiltInProperty.HISTORY_FILE, SqlLineOpts.this::setHistoryFile);
            this.put(BuiltInProperty.MAX_HISTORY_FILE_ROWS, SqlLineOpts.this::setMaxHistoryFileRows);
            this.put(BuiltInProperty.MAX_HISTORY_ROWS, SqlLineOpts.this::setMaxHistoryRows);
            this.put(BuiltInProperty.MODE, SqlLineOpts.this::setMode);
            this.put(BuiltInProperty.NUMBER_FORMAT, SqlLineOpts.this::setNumberFormat);
            this.put(BuiltInProperty.OUTPUT_FORMAT, SqlLineOpts.this::setOutputFormat);
            this.put(BuiltInProperty.PROPERTIES_FILE, SqlLineOpts.this::setPropertiesFile);
            this.put(BuiltInProperty.SHOW_COMPLETION_DESCR, SqlLineOpts.this::setShowCompletionDesc);
            this.put(BuiltInProperty.TIME_FORMAT, SqlLineOpts.this::setTimeFormat);
            this.put(BuiltInProperty.TIMESTAMP_FORMAT, SqlLineOpts.this::setTimestampFormat);
        }
    });

    public SqlLineOpts(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public SqlLineOpts(SqlLine sqlLine, Properties props) {
        this(sqlLine);
        this.loadProperties(props);
    }

    public List<Completer> resetOptionCompleters() {
        return Collections.singletonList(this);
    }

    public List<Completer> setOptionCompleters(Map<BuiltInProperty, Collection<String>> customCompletions) {
        String propertyValueKey;
        String propertyName;
        HashMap<String, StringsCompleter> comp = new HashMap<String, StringsCompleter>();
        String start = "START";
        comp.put("START", new StringsCompleter(new SqlLineCommandCompleter.SqlLineCandidate(this.sqlLine, "!set", "!set", this.sqlLine.loc("command-name", new Object[0]), this.sqlLine.loc("help-set", new Object[0]), null, "!set", true)));
        ArrayList<BuiltInProperty> booleanProperties = new ArrayList<BuiltInProperty>();
        ArrayList<BuiltInProperty> withDefinedAvailableValues = new ArrayList<BuiltInProperty>();
        StringBuilder sb = new StringBuilder("START (");
        for (BuiltInProperty builtInProperty : BuiltInProperty.values()) {
            if (customCompletions.containsKey(builtInProperty)) continue;
            if (!builtInProperty.getAvailableValues().isEmpty()) {
                withDefinedAvailableValues.add(builtInProperty);
                continue;
            }
            if (builtInProperty.type() == SqlLineProperty.Type.BOOLEAN) {
                booleanProperties.add(builtInProperty);
                continue;
            }
            sb.append(builtInProperty.name()).append(" | ");
            comp.put(builtInProperty.name(), new StringsCompleter(builtInProperty.propertyName()));
        }
        String booleanTypeString = SqlLineProperty.Type.BOOLEAN.toString();
        sb.append(booleanTypeString);
        comp.put(booleanTypeString, new StringsCompleter((String[])booleanProperties.stream().map(BuiltInProperty::propertyName).toArray(String[]::new)));
        String booleanPropertyValueKey = booleanTypeString + "_value";
        comp.put(booleanPropertyValueKey, new StringsCompleter(BuiltInProperty.BOOLEAN_VALUES));
        sb.append(" ").append(booleanPropertyValueKey);
        for (BuiltInProperty builtInProperty : withDefinedAvailableValues) {
            propertyName = builtInProperty.propertyName();
            sb.append(" | ").append(propertyName);
            comp.put(propertyName, new StringsCompleter(propertyName));
            propertyValueKey = propertyName + "_value";
            comp.put(propertyValueKey, new StringsCompleter(builtInProperty.getAvailableValues().toArray(new String[0])));
            sb.append(" ").append(propertyValueKey);
        }
        for (Map.Entry entry : customCompletions.entrySet()) {
            propertyName = ((BuiltInProperty)entry.getKey()).propertyName();
            comp.put(propertyName, new StringsCompleter(propertyName));
            propertyValueKey = propertyName + "_value";
            comp.put(propertyValueKey, new StringsCompleter(((Collection)entry.getValue()).toArray(new String[0])));
            sb.append("| ").append(propertyName).append(" ").append(propertyValueKey);
        }
        sb.append(") ");
        return Collections.singletonList(new Completers.RegexCompleter(sb.toString(), comp::get));
    }

    public static File saveDir() {
        String dir = System.getProperty("sqlline.rcfile");
        if (dir != null && dir.length() > 0) {
            return new File(dir);
        }
        String baseDir = System.getProperty("x.sqlline.basedir");
        if (baseDir != null && baseDir.length() > 0) {
            File saveDir = new File(baseDir).getAbsoluteFile();
            saveDir.mkdirs();
            return saveDir;
        }
        File f = new File(System.getProperty("user.home"), (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows") ? "" : ".") + "sqlline").getAbsoluteFile();
        try {
            f.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    @Override
    public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
        try {
            new StringsCompleter(this.propertyNames()).complete(lineReader, parsedLine, list);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        String pathToPropertyFile = this.get(BuiltInProperty.PROPERTIES_FILE);
        if (DEV_NULL.equals(pathToPropertyFile)) {
            this.sqlLine.error(this.sqlLine.loc("saving-to-dev-null-not-supported", new Object[0]));
            return;
        }
        FileOutputStream out = new FileOutputStream(pathToPropertyFile);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(OutputStream out) {
        try {
            Properties props = this.toProperties(true);
            props.store(out, this.sqlLine.getApplicationTitle());
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
    }

    public Set<String> propertyNames() {
        if (this.propertyNames != null) {
            return this.propertyNames;
        }
        Set set = Arrays.stream(BuiltInProperty.values()).map(t -> t.propertyName().toLowerCase(Locale.ROOT)).collect(Collectors.toCollection(TreeSet::new));
        this.propertyNames = Collections.unmodifiableSet(set);
        return this.propertyNames;
    }

    public Properties toProperties() {
        return this.toProperties(false);
    }

    public Properties toProperties(boolean toSave) {
        Properties props = new Properties();
        for (BuiltInProperty property : BuiltInProperty.values()) {
            if (toSave && !property.couldBeStored()) continue;
            props.setProperty(PROPERTY_PREFIX + property.propertyName(), String.valueOf(this.propertiesMap.getOrDefault(property, property.defaultValue())));
        }
        this.sqlLine.debug("properties: " + props.toString());
        return props;
    }

    public void load() throws IOException {
        File rcFile = new File(this.getPropertiesFile());
        if (rcFile.exists()) {
            FileInputStream in = new FileInputStream(rcFile);
            this.load(in);
            ((InputStream)in).close();
        }
    }

    public void load(InputStream fin) throws IOException {
        Properties p = new Properties();
        p.load(fin);
        this.loadProperties(p);
    }

    public void loadProperties(Properties props) {
        for (String key : Commands.asMap(props).keySet()) {
            if (key.equals(PROPERTY_NAME_EXIT) || !key.startsWith(PROPERTY_PREFIX)) continue;
            this.set(key.substring(PROPERTY_PREFIX.length()), props.getProperty(key));
        }
    }

    public void set(String key, String value) {
        this.set(key, value, false);
    }

    public boolean set(String key, String value, boolean quiet) {
        if ("run".equals(key)) {
            this.setRun(value);
            return true;
        }
        SqlLineProperty property = BuiltInProperty.valueOf(key, true);
        if (property == null) {
            if (!quiet) {
                System.err.println(this.sqlLine.loc("unknown-prop", key));
            }
            return false;
        }
        if (property.isReadOnly()) {
            if (!quiet) {
                this.sqlLine.error(this.sqlLine.loc("property-readonly", key));
            }
            return false;
        }
        SqlLineProperty.Writer propertyWriter = this.propertiesConfig.get(property);
        if (propertyWriter != null) {
            propertyWriter.write(value);
        } else {
            this.set(property, (Object)value);
        }
        return true;
    }

    public boolean hasProperty(String name) {
        try {
            return this.propertyNames().contains(name);
        }
        catch (Exception e) {
            this.sqlLine.debug(e.getMessage());
            return false;
        }
    }

    public String get(SqlLineProperty key) {
        return String.valueOf(this.propertiesMap.getOrDefault(key, key.defaultValue()));
    }

    public char getChar(SqlLineProperty key) {
        if (key.type() == SqlLineProperty.Type.CHAR) {
            return ((Character)this.propertiesMap.getOrDefault(key, key.defaultValue())).charValue();
        }
        throw new IllegalArgumentException(this.sqlLine.loc("wrong-prop-type", new Object[]{key.propertyName(), key.type()}));
    }

    public int getInt(SqlLineProperty key) {
        if (key.type() == SqlLineProperty.Type.INTEGER) {
            return (Integer)this.propertiesMap.getOrDefault(key, key.defaultValue());
        }
        throw new IllegalArgumentException(this.sqlLine.loc("wrong-prop-type", new Object[]{key.propertyName(), key.type()}));
    }

    public boolean getBoolean(SqlLineProperty key) {
        if (key.type() == SqlLineProperty.Type.BOOLEAN) {
            return (Boolean)this.propertiesMap.getOrDefault(key, key.defaultValue());
        }
        throw new IllegalArgumentException(this.sqlLine.loc("wrong-prop-type", new Object[]{key.propertyName(), key.type()}));
    }

    public boolean isDefault(SqlLineProperty property) {
        String defaultValue = String.valueOf(property.defaultValue());
        Object currentValue = this.propertiesMap.getOrDefault(property, property.defaultValue());
        return currentValue == null || Objects.equals(String.valueOf(currentValue), defaultValue);
    }

    public String get(String key) {
        SqlLineProperty property = BuiltInProperty.valueOf(key, true);
        if (property == null) {
            return null;
        }
        Object o = this.propertiesMap.getOrDefault(property, property.defaultValue());
        return String.valueOf(o);
    }

    public void set(SqlLineProperty key, Object value) {
        Object valueToSet = value;
        switch (key.type()) {
            case STRING: {
                String strValue = value instanceof String ? (String)value : String.valueOf(value);
                Object object = valueToSet = "default".equalsIgnoreCase(strValue) ? key.defaultValue() : value;
                if (key.getAvailableValues().isEmpty() || key.getAvailableValues().contains(valueToSet.toString())) break;
                this.sqlLine.error(this.sqlLine.loc("unknown-value", key.propertyName(), value, key.getAvailableValues()));
                return;
            }
            case INTEGER: {
                try {
                    valueToSet = value instanceof Integer || value.getClass() == Integer.TYPE ? value : Integer.valueOf(Integer.parseInt(String.valueOf(value)));
                    break;
                }
                catch (Exception e) {
                    this.sqlLine.error(this.sqlLine.loc("not-a-number", key.propertyName().toLowerCase(Locale.ROOT), value));
                    if (this.getVerbose()) {
                        this.sqlLine.handleException(e);
                    }
                    return;
                }
            }
            case BOOLEAN: {
                String strValue;
                valueToSet = value instanceof Boolean || value.getClass() == Boolean.TYPE ? value : Boolean.valueOf("true".equalsIgnoreCase(strValue = String.valueOf(value)) || "1".equalsIgnoreCase(strValue) || "on".equalsIgnoreCase(strValue) || "yes".equalsIgnoreCase(strValue));
            }
        }
        this.propertiesMap.put(key, valueToSet);
    }

    public boolean getFastConnect() {
        return this.getBoolean(BuiltInProperty.FAST_CONNECT);
    }

    public boolean getAutoCommit() {
        return this.getBoolean(BuiltInProperty.AUTO_COMMIT);
    }

    public boolean getReadOnly() {
        return this.getBoolean(BuiltInProperty.READ_ONLY);
    }

    public boolean getVerbose() {
        return this.getBoolean(BuiltInProperty.VERBOSE);
    }

    public boolean getShowElapsedTime() {
        return this.getBoolean(BuiltInProperty.SHOW_ELAPSED_TIME);
    }

    public boolean getShowWarnings() {
        return this.getBoolean(BuiltInProperty.SHOW_WARNINGS);
    }

    public boolean getShowCompletionDescr() {
        return this.getBoolean(BuiltInProperty.SHOW_COMPLETION_DESCR);
    }

    public boolean getShowNestedErrs() {
        return this.getBoolean(BuiltInProperty.SHOW_NESTED_ERRS);
    }

    public String getNumberFormat() {
        return this.get(BuiltInProperty.NUMBER_FORMAT);
    }

    public boolean getEscapeOutput() {
        return this.getBoolean(BuiltInProperty.ESCAPE_OUTPUT);
    }

    public void setNumberFormat(String numberFormat) {
        if ("default".equalsIgnoreCase(numberFormat)) {
            this.propertiesMap.put(BuiltInProperty.NUMBER_FORMAT, BuiltInProperty.NUMBER_FORMAT.defaultValue());
            return;
        }
        try {
            DecimalFormat nf = new DecimalFormat(numberFormat, DecimalFormatSymbols.getInstance(Locale.ROOT));
            nf.format(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.propertiesMap.put(BuiltInProperty.NUMBER_FORMAT, numberFormat);
    }

    public String getDateFormat() {
        return this.get(BuiltInProperty.DATE_FORMAT);
    }

    public void setDateFormat(String dateFormat) {
        this.set(BuiltInProperty.DATE_FORMAT, (Object)this.getValidDateTimePatternOrThrow(dateFormat));
    }

    public String getTimeFormat() {
        return this.get(BuiltInProperty.TIME_FORMAT);
    }

    public void setTimeFormat(String timeFormat) {
        this.set(BuiltInProperty.TIME_FORMAT, (Object)this.getValidDateTimePatternOrThrow(timeFormat));
    }

    public String getTimestampFormat() {
        return this.get(BuiltInProperty.TIMESTAMP_FORMAT);
    }

    public void setTimestampFormat(String timestampFormat) {
        this.set(BuiltInProperty.TIMESTAMP_FORMAT, (Object)this.getValidDateTimePatternOrThrow(timestampFormat));
    }

    public void setShowCompletionDesc(String setShowCompletionDesc) {
        this.set(BuiltInProperty.SHOW_COMPLETION_DESCR, (Object)setShowCompletionDesc);
    }

    public String getNullValue() {
        return this.get(BuiltInProperty.NULL_VALUE);
    }

    public int getRowLimit() {
        return this.getInt(BuiltInProperty.ROW_LIMIT);
    }

    public int getTimeout() {
        return this.getInt(BuiltInProperty.TIMEOUT);
    }

    public String getIsolation() {
        return this.get(BuiltInProperty.ISOLATION);
    }

    public void setIsolation(String isolation) {
        this.set(BuiltInProperty.ISOLATION, (Object)isolation.toUpperCase(Locale.ROOT));
    }

    public String getHistoryFile() {
        return this.get(BuiltInProperty.HISTORY_FILE);
    }

    public void setHistoryFile(String historyFile) {
        String currentValue = this.get(BuiltInProperty.HISTORY_FILE);
        if (Objects.equals(currentValue, historyFile) || Objects.equals(currentValue, Commands.expand(historyFile))) {
            return;
        }
        if ("default".equalsIgnoreCase(historyFile)) {
            this.set(BuiltInProperty.HISTORY_FILE, (Object)"default");
        } else {
            this.propertiesMap.put(BuiltInProperty.HISTORY_FILE, Commands.expand(historyFile));
        }
        if (this.sqlLine != null && this.sqlLine.getLineReader() != null) {
            History history = this.sqlLine.getLineReader().getHistory();
            if (history == null) {
                history = new DefaultHistory();
            } else {
                try {
                    history.save();
                }
                catch (IOException e) {
                    this.sqlLine.handleException(e);
                }
            }
            this.sqlLine.getLineReader().setVariable("history-file", this.get(BuiltInProperty.HISTORY_FILE));
            history.attach(this.sqlLine.getLineReader());
        }
    }

    public void setColorScheme(String colorScheme) {
        if ("default".equals(colorScheme) || BuiltInHighlightStyle.BY_NAME.containsKey(colorScheme)) {
            this.propertiesMap.put(BuiltInProperty.COLOR_SCHEME, colorScheme);
            return;
        }
        this.sqlLine.error(this.sqlLine.loc("unknown-value", BuiltInProperty.COLOR_SCHEME.propertyName(), colorScheme, BuiltInProperty.COLOR_SCHEME.getAvailableValues()));
    }

    public String getColorScheme() {
        return this.get(BuiltInProperty.COLOR_SCHEME);
    }

    public boolean getColor() {
        return this.getBoolean(BuiltInProperty.COLOR);
    }

    public String getCsvDelimiter() {
        return this.get(BuiltInProperty.CSV_DELIMITER);
    }

    public char getCsvQuoteCharacter() {
        return this.getChar(BuiltInProperty.CSV_QUOTE_CHARACTER);
    }

    public void setMaxHistoryRows(String maxHistoryRows) {
        this.setLineReaderHistoryIntVariable("history-size", maxHistoryRows, BuiltInProperty.MAX_HISTORY_ROWS);
    }

    public void setMaxHistoryFileRows(String maxHistoryFileRows) {
        this.setLineReaderHistoryIntVariable("history-file-size", maxHistoryFileRows, BuiltInProperty.MAX_HISTORY_FILE_ROWS);
    }

    private void setLineReaderHistoryIntVariable(String variableName, String value, SqlLineProperty property) {
        LineReader lineReader = this.sqlLine.getLineReader();
        if (lineReader == null) {
            return;
        }
        int currentValue = this.getInt(property);
        try {
            if ("default".equals(value)) {
                if (currentValue == (Integer)property.defaultValue()) {
                    return;
                }
                lineReader.setVariable(variableName, property.defaultValue());
                lineReader.getHistory().save();
                this.propertiesMap.put(property, property.defaultValue());
                return;
            }
            int parsedValue = Integer.parseInt(value);
            if (parsedValue == currentValue) {
                return;
            }
            lineReader.setVariable(variableName, parsedValue);
            lineReader.getHistory().save();
            this.propertiesMap.put(property, parsedValue);
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
    }

    public void setCsvQuoteCharacter(String csvQuoteCharacter) {
        if ("default".equals(csvQuoteCharacter)) {
            this.propertiesMap.put(BuiltInProperty.CSV_QUOTE_CHARACTER, BuiltInProperty.CSV_QUOTE_CHARACTER.defaultValue());
            return;
        }
        if (csvQuoteCharacter != null) {
            if (csvQuoteCharacter.length() == 1) {
                this.propertiesMap.put(BuiltInProperty.CSV_QUOTE_CHARACTER, Character.valueOf(csvQuoteCharacter.charAt(0)));
                return;
            }
            if (csvQuoteCharacter.length() == 2 && csvQuoteCharacter.charAt(0) == '\\') {
                this.propertiesMap.put(BuiltInProperty.CSV_QUOTE_CHARACTER, Character.valueOf(csvQuoteCharacter.charAt(1)));
                return;
            }
        }
        this.sqlLine.error("CsvQuoteCharacter is '" + csvQuoteCharacter + "'; it must be a character or default");
    }

    public boolean getShowHeader() {
        return this.getBoolean(BuiltInProperty.SHOW_HEADER);
    }

    public int getHeaderInterval() {
        return this.getInt(BuiltInProperty.HEADER_INTERVAL);
    }

    public boolean getForce() {
        return this.getBoolean(BuiltInProperty.FORCE);
    }

    public boolean getIncremental() {
        return this.getBoolean(BuiltInProperty.INCREMENTAL);
    }

    public int getIncrementalBufferRows() {
        return this.getInt(BuiltInProperty.INCREMENTAL_BUFFER_ROWS);
    }

    public boolean getSilent() {
        return this.getBoolean(BuiltInProperty.SILENT);
    }

    @Deprecated
    public boolean getAutosave() {
        return this.getAutoSave();
    }

    public boolean getAutoSave() {
        return this.getBoolean(BuiltInProperty.AUTO_SAVE);
    }

    public boolean getShowLineNumbers() {
        return this.getBoolean(BuiltInProperty.SHOW_LINE_NUMBERS);
    }

    public String getOutputFormat() {
        return this.get(BuiltInProperty.OUTPUT_FORMAT);
    }

    public String getPrompt() {
        return this.get(BuiltInProperty.PROMPT);
    }

    public String getRightPrompt() {
        return this.get(BuiltInProperty.RIGHT_PROMPT);
    }

    public boolean getTrimScripts() {
        return this.getBoolean(BuiltInProperty.TRIM_SCRIPTS);
    }

    public int getMaxHeight() {
        return this.getInt(BuiltInProperty.MAX_HEIGHT);
    }

    public int getMaxWidth() {
        return this.getInt(BuiltInProperty.MAX_WIDTH);
    }

    public int getMaxColumnWidth() {
        return this.getInt(BuiltInProperty.MAX_COLUMN_WIDTH);
    }

    public boolean getUseLineContinuation() {
        return this.getBoolean(BuiltInProperty.USE_LINE_CONTINUATION);
    }

    public String getMode() {
        return this.get(BuiltInProperty.MODE);
    }

    public void setMode(String mode) {
        LineReader reader = this.sqlLine.getLineReader();
        if (reader == null || reader.getKeyMaps() == null) {
            return;
        }
        Map<String, KeyMap<Binding>> keyMaps = reader.getKeyMaps();
        switch (mode) {
            case "emacs": 
            case "default": {
                this.set(BuiltInProperty.MODE, (Object)"emacs");
                keyMaps.put("main", keyMaps.get("emacs"));
                break;
            }
            case "vi": {
                this.set(BuiltInProperty.MODE, (Object)mode);
                keyMaps.put("main", keyMaps.get("viins"));
                break;
            }
            default: {
                this.sqlLine.error(this.sqlLine.loc("unknown-value", BuiltInProperty.MODE.propertyName(), mode, Arrays.asList("emacs", "vi")));
            }
        }
    }

    public void setOutputFormat(String outputFormat) {
        if ("default".equalsIgnoreCase(outputFormat)) {
            this.set(BuiltInProperty.OUTPUT_FORMAT, BuiltInProperty.OUTPUT_FORMAT.defaultValue());
            return;
        }
        Set availableFormats = this.sqlLine.getOutputFormats().keySet().stream().map(t -> t.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        if (availableFormats.contains(outputFormat.toUpperCase(Locale.ROOT))) {
            this.set(BuiltInProperty.OUTPUT_FORMAT, (Object)outputFormat);
        } else {
            this.sqlLine.error(this.sqlLine.loc("unknown-value", BuiltInProperty.OUTPUT_FORMAT.propertyName(), outputFormat, this.sqlLine.getOutputFormats().keySet()));
        }
    }

    public boolean getStrictJdbc() {
        return this.getBoolean(BuiltInProperty.STRICT_JDBC);
    }

    public String getPropertiesFile() {
        return this.get(BuiltInProperty.PROPERTIES_FILE);
    }

    public void setPropertiesFile(String propertyFile) {
        String oldPropertyFile = this.get(BuiltInProperty.PROPERTIES_FILE);
        if (Objects.equals(propertyFile, oldPropertyFile) || Objects.equals(BuiltInProperty.PROPERTIES_FILE.defaultValue(), oldPropertyFile) && "default".equalsIgnoreCase(propertyFile)) {
            return;
        }
        this.propertiesMap.clear();
        this.set(BuiltInProperty.PROPERTIES_FILE, (Object)propertyFile);
        if (DEV_NULL.equals(propertyFile)) {
            return;
        }
        try {
            this.load();
        }
        catch (IOException e) {
            this.sqlLine.handleException(e);
        }
    }

    public void setRun(String runFile) {
        this.runFile = runFile;
    }

    public String getRun() {
        return this.runFile;
    }

    public boolean getConfirm() {
        return this.getBoolean(BuiltInProperty.CONFIRM);
    }

    public String getConfirmPattern() {
        return this.get(BuiltInProperty.CONFIRM_PATTERN);
    }

    public void setConfirmPattern(String confirmPattern) {
        this.set(BuiltInProperty.CONFIRM_PATTERN, (Object)this.getValidConfirmPatternOrThrow(confirmPattern));
    }

    private String getValidDateTimePatternOrThrow(String dateTimePattern) {
        if ("default".equalsIgnoreCase(dateTimePattern)) {
            return dateTimePattern;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateTimePattern, Locale.ROOT);
            sdf.format(TEST_DATE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return dateTimePattern;
    }

    private String getValidConfirmPatternOrThrow(String confirmPattern) {
        if (confirmPattern == null) {
            throw new IllegalArgumentException("Confirm pattern is null");
        }
        if ("default".equalsIgnoreCase(confirmPattern)) {
            confirmPattern = this.sqlLine.loc("default-confirm-pattern", new Object[0]);
        }
        this.set(BuiltInProperty.CONFIRM_PATTERN, (Object)confirmPattern);
        try {
            this.compiledConfirmPattern = Pattern.compile(confirmPattern);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("confirmPattern is invalid regex: " + confirmPattern);
        }
        return confirmPattern;
    }

    public Pattern getCompiledConfirmPattern() {
        if (this.compiledConfirmPattern == null) {
            this.compiledConfirmPattern = Pattern.compile(this.getConfirmPattern());
        }
        return this.compiledConfirmPattern;
    }

    public String getHistoryFlags() {
        return this.get(BuiltInProperty.HISTORY_FLAGS);
    }
}

